/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.TableMeta;
import org.apache.tajo.catalog.statistics.TableStats;
import org.apache.tajo.storage.Scanner;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.storage.fragment.Fragment;

public class NullScanner
implements Scanner {
    protected final Configuration conf;
    protected final TableMeta meta;
    protected final Schema schema;
    protected final Fragment fragment;
    protected final int columnNum;
    protected Column[] targets;
    protected float progress;
    protected TableStats tableStats;

    public NullScanner(Configuration conf, Schema schema, TableMeta meta, Fragment fragment) {
        this.conf = conf;
        this.meta = meta;
        this.schema = schema;
        this.fragment = fragment;
        this.tableStats = new TableStats();
        this.columnNum = this.schema.size();
    }

    @Override
    public void init() throws IOException {
        this.progress = 0.0f;
        this.tableStats.setNumBytes(0L);
        this.tableStats.setNumBlocks(0);
    }

    @Override
    public Tuple next() throws IOException {
        this.progress = 1.0f;
        return null;
    }

    @Override
    public void reset() throws IOException {
        this.progress = 0.0f;
    }

    @Override
    public void close() throws IOException {
        this.progress = 1.0f;
    }

    @Override
    public boolean isProjectable() {
        return false;
    }

    @Override
    public void setTarget(Column[] targets) {
        this.targets = targets;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void setSearchCondition(Object expr) {
    }

    @Override
    public boolean isSplittable() {
        return true;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public TableStats getInputStats() {
        return this.tableStats;
    }

    public Schema getSchema() {
        return this.schema;
    }
}

