/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.TableMeta;
import org.apache.tajo.catalog.statistics.ColumnStats;
import org.apache.tajo.catalog.statistics.TableStats;
import org.apache.tajo.conf.TajoConf;
import org.apache.tajo.storage.Scanner;
import org.apache.tajo.storage.StorageManager;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.storage.fragment.Fragment;

public class MergeScanner
implements Scanner {
    private Configuration conf;
    private TableMeta meta;
    private Schema schema;
    private List<Fragment> fragments;
    private Iterator<Fragment> iterator;
    private Fragment currentFragment;
    private Scanner currentScanner;
    private Tuple tuple;
    private boolean projectable = false;
    private boolean selectable = false;
    private Schema target;
    private float progress;
    protected TableStats tableStats;

    public MergeScanner(Configuration conf, Schema schema, TableMeta meta, List<Fragment> rawFragmentList) throws IOException {
        this(conf, schema, meta, rawFragmentList, schema);
    }

    public MergeScanner(Configuration conf, Schema schema, TableMeta meta, List<Fragment> rawFragmentList, Schema target) throws IOException {
        this.conf = conf;
        this.schema = schema;
        this.meta = meta;
        this.target = target;
        this.fragments = new ArrayList<Fragment>();
        long numBytes = 0L;
        for (Fragment eachFileFragment : rawFragmentList) {
            long fragmentLength = StorageManager.getFragmentLength((TajoConf)conf, eachFileFragment);
            if (fragmentLength <= 0L) continue;
            numBytes += fragmentLength;
            this.fragments.add(eachFileFragment);
        }
        this.reset();
        if (this.currentScanner != null) {
            this.projectable = this.currentScanner.isProjectable();
            this.selectable = this.currentScanner.isSelectable();
        }
        this.tableStats = new TableStats();
        this.tableStats.setNumBytes(numBytes);
        this.tableStats.setNumBlocks(this.fragments.size());
        for (Column eachColumn : schema.getColumns()) {
            ColumnStats columnStats = new ColumnStats(eachColumn);
            this.tableStats.addColumnStat(columnStats);
        }
    }

    @Override
    public void init() throws IOException {
        this.progress = 0.0f;
    }

    @Override
    public Tuple next() throws IOException {
        if (this.currentScanner != null) {
            this.tuple = this.currentScanner.next();
        }
        if (this.tuple != null) {
            return this.tuple;
        }
        if (this.currentScanner != null) {
            this.currentScanner.close();
            TableStats scannerTableStsts = this.currentScanner.getInputStats();
            if (scannerTableStsts != null) {
                this.tableStats.setReadBytes(this.tableStats.getReadBytes() + scannerTableStsts.getReadBytes());
                this.tableStats.setNumRows(this.tableStats.getNumRows() + scannerTableStsts.getNumRows());
            }
        }
        this.currentScanner = this.getNextScanner();
        if (this.currentScanner != null) {
            this.tuple = this.currentScanner.next();
        }
        return this.tuple;
    }

    @Override
    public void reset() throws IOException {
        this.iterator = this.fragments.iterator();
        if (this.currentScanner != null) {
            this.currentScanner.close();
        }
        this.currentScanner = this.getNextScanner();
    }

    private Scanner getNextScanner() throws IOException {
        if (this.iterator.hasNext()) {
            this.currentFragment = this.iterator.next();
            this.currentScanner = StorageManager.getStorageManager((TajoConf)this.conf, this.meta.getStoreType()).getScanner(this.meta, this.schema, this.currentFragment, this.target);
            this.currentScanner.init();
            return this.currentScanner;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.currentScanner != null) {
            this.currentScanner.close();
            this.currentScanner = null;
        }
        this.iterator = null;
        this.progress = 1.0f;
    }

    @Override
    public boolean isProjectable() {
        return this.projectable;
    }

    @Override
    public void setTarget(Column[] targets) {
        this.target = new Schema(targets);
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public void setSearchCondition(Object expr) {
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public boolean isSplittable() {
        return false;
    }

    @Override
    public float getProgress() {
        if (this.currentScanner != null && this.iterator != null && this.tableStats.getNumBytes() > 0L) {
            TableStats scannerTableStsts = this.currentScanner.getInputStats();
            long currentScannerReadBytes = 0L;
            if (scannerTableStsts != null) {
                currentScannerReadBytes = scannerTableStsts.getReadBytes();
            }
            return (float)(this.tableStats.getReadBytes() + currentScannerReadBytes) / (float)this.tableStats.getNumBytes().longValue();
        }
        return this.progress;
    }

    @Override
    public TableStats getInputStats() {
        return this.tableStats;
    }
}

