/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import org.apache.tajo.datum.BitDatum;
import org.apache.tajo.datum.BlobDatum;
import org.apache.tajo.datum.BooleanDatum;
import org.apache.tajo.datum.CharDatum;
import org.apache.tajo.datum.DateDatum;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.Float4Datum;
import org.apache.tajo.datum.Float8Datum;
import org.apache.tajo.datum.Int2Datum;
import org.apache.tajo.datum.Int4Datum;
import org.apache.tajo.datum.Int8Datum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.TextDatum;
import org.apache.tajo.datum.TimeDatum;
import org.apache.tajo.datum.TimestampDatum;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.util.ClassSize;

public class MemoryUtil {
    public static final long NULL_DATUM = ClassSize.estimateBase(NullDatum.class, (boolean)false);
    public static final long BOOL_DATUM;
    public static final long CHAR_DATUM;
    public static final long BIT_DATUM;
    public static final long INT2_DATUM;
    public static final long INT4_DATUM;
    public static final long INT8_DATUM;
    public static final long FLOAT4_DATUM;
    public static final long FLOAT8_DATUM;
    public static final long TEXT_DATUM;
    public static final long BLOB_DATUM;
    public static final long DATE_DATUM;
    public static final long TIME_DATUM;
    public static final long TIMESTAMP_DATUM;

    public static long calculateMemorySize(Tuple tuple) {
        long total = ClassSize.OBJECT;
        block15: for (Datum datum : tuple.getValues()) {
            switch (datum.type()) {
                case NULL_TYPE: {
                    total += NULL_DATUM;
                    continue block15;
                }
                case BOOLEAN: {
                    total += BOOL_DATUM;
                    continue block15;
                }
                case BIT: {
                    total += BIT_DATUM;
                    continue block15;
                }
                case CHAR: {
                    total += CHAR_DATUM + (long)datum.size();
                    continue block15;
                }
                case INT1: 
                case INT2: {
                    total += INT2_DATUM;
                    continue block15;
                }
                case INT4: {
                    total += INT4_DATUM;
                    continue block15;
                }
                case INT8: {
                    total += INT8_DATUM;
                    continue block15;
                }
                case FLOAT4: {
                    total += FLOAT4_DATUM;
                    continue block15;
                }
                case FLOAT8: {
                    total += FLOAT4_DATUM;
                    continue block15;
                }
                case TEXT: {
                    total += TEXT_DATUM + (long)datum.size();
                    continue block15;
                }
                case DATE: {
                    total += DATE_DATUM;
                    continue block15;
                }
                case TIME: {
                    total += TIME_DATUM;
                    continue block15;
                }
                case TIMESTAMP: {
                    total += TIMESTAMP_DATUM;
                    continue block15;
                }
            }
        }
        return total;
    }

    static {
        CHAR_DATUM = ClassSize.estimateBase(CharDatum.class, (boolean)false);
        BOOL_DATUM = ClassSize.estimateBase(BooleanDatum.class, (boolean)false);
        BIT_DATUM = ClassSize.estimateBase(BitDatum.class, (boolean)false);
        INT2_DATUM = ClassSize.estimateBase(Int2Datum.class, (boolean)false);
        INT4_DATUM = ClassSize.estimateBase(Int4Datum.class, (boolean)false);
        INT8_DATUM = ClassSize.estimateBase(Int8Datum.class, (boolean)false);
        FLOAT4_DATUM = ClassSize.estimateBase(Float4Datum.class, (boolean)false);
        FLOAT8_DATUM = ClassSize.estimateBase(Float8Datum.class, (boolean)false);
        TEXT_DATUM = ClassSize.estimateBase(TextDatum.class, (boolean)false);
        BLOB_DATUM = ClassSize.estimateBase(BlobDatum.class, (boolean)false);
        DATE_DATUM = ClassSize.estimateBase(DateDatum.class, (boolean)false);
        TIME_DATUM = ClassSize.estimateBase(TimeDatum.class, (boolean)false);
        TIMESTAMP_DATUM = ClassSize.estimateBase(TimestampDatum.class, (boolean)false);
    }
}

