/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import java.util.Arrays;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.exception.UnsupportedException;
import org.apache.tajo.storage.SerializerDeserializer;
import org.apache.tajo.storage.TextSerializerDeserializer;
import org.apache.tajo.storage.Tuple;

public class LazyTuple
implements Tuple,
Cloneable {
    private long offset;
    private Datum[] values;
    private byte[][] textBytes;
    private Schema schema;
    private byte[] nullBytes;
    private SerializerDeserializer serializeDeserialize;

    public LazyTuple(Schema schema, byte[][] textBytes, long offset) {
        this(schema, textBytes, offset, NullDatum.get().asTextBytes(), new TextSerializerDeserializer());
    }

    public LazyTuple(Schema schema, byte[][] textBytes, long offset, byte[] nullBytes, SerializerDeserializer serde) {
        this.schema = schema;
        this.textBytes = textBytes;
        this.values = new Datum[schema.size()];
        this.offset = offset;
        this.nullBytes = nullBytes;
        this.serializeDeserialize = serde;
    }

    public LazyTuple(LazyTuple tuple) {
        this.values = tuple.getValues();
        this.offset = tuple.offset;
        this.schema = tuple.schema;
        this.textBytes = new byte[this.size()][];
        this.nullBytes = tuple.nullBytes;
        this.serializeDeserialize = tuple.serializeDeserialize;
    }

    public int size() {
        return this.values.length;
    }

    public boolean contains(int fieldid) {
        return this.textBytes[fieldid] != null || this.values[fieldid] != null;
    }

    public boolean isNull(int fieldid) {
        return this.get(fieldid).isNull();
    }

    public boolean isNotNull(int fieldid) {
        return !this.isNull(fieldid);
    }

    public void clear() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
            this.textBytes[i] = null;
        }
    }

    public void put(int fieldId, Datum value) {
        this.values[fieldId] = value;
        this.textBytes[fieldId] = null;
    }

    public void put(int fieldId, Datum[] values) {
        int i = fieldId;
        for (int j = 0; j < values.length; ++j) {
            this.values[i] = values[j];
            ++i;
        }
        this.textBytes = new byte[values.length][];
    }

    public void put(int fieldId, Tuple tuple) {
        int i = fieldId;
        for (int j = 0; j < tuple.size(); ++j) {
            this.values[i] = tuple.get(j);
            this.textBytes[i] = null;
            ++i;
        }
    }

    public void put(Datum[] values) {
        System.arraycopy(values, 0, this.values, 0, this.size());
        this.textBytes = new byte[values.length][];
    }

    public Datum get(int fieldId) {
        if (this.values[fieldId] != null) {
            return this.values[fieldId];
        }
        if (this.textBytes.length <= fieldId) {
            this.values[fieldId] = NullDatum.get();
        } else if (this.textBytes[fieldId] != null) {
            try {
                this.values[fieldId] = this.serializeDeserialize.deserialize(this.schema.getColumn(fieldId), this.textBytes[fieldId], 0, this.textBytes[fieldId].length, this.nullBytes);
            }
            catch (Exception e) {
                this.values[fieldId] = NullDatum.get();
            }
            this.textBytes[fieldId] = null;
        }
        return this.values[fieldId];
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean getBool(int fieldId) {
        return this.get(fieldId).asBool();
    }

    public byte getByte(int fieldId) {
        return this.get(fieldId).asByte();
    }

    public char getChar(int fieldId) {
        return this.get(fieldId).asChar();
    }

    public byte[] getBytes(int fieldId) {
        return this.get(fieldId).asByteArray();
    }

    public short getInt2(int fieldId) {
        return this.get(fieldId).asInt2();
    }

    public int getInt4(int fieldId) {
        return this.get(fieldId).asInt4();
    }

    public long getInt8(int fieldId) {
        return this.get(fieldId).asInt8();
    }

    public float getFloat4(int fieldId) {
        return this.get(fieldId).asFloat4();
    }

    public double getFloat8(int fieldId) {
        return this.get(fieldId).asFloat8();
    }

    public String getText(int fieldId) {
        return this.get(fieldId).asChars();
    }

    public ProtobufDatum getProtobufDatum(int fieldId) {
        throw new UnsupportedException();
    }

    public IntervalDatum getInterval(int fieldId) {
        return (IntervalDatum)this.get(fieldId);
    }

    public char[] getUnicodeChars(int fieldId) {
        return this.get(fieldId).asUnicodeChars();
    }

    public String toString() {
        boolean first = true;
        StringBuilder str = new StringBuilder();
        str.append("(");
        for (int i = 0; i < this.values.length; ++i) {
            Datum d = this.get(i);
            if (d == null) continue;
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(i).append("=>").append(d);
        }
        str.append(")");
        return str.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public Datum[] getValues() {
        Datum[] datums = new Datum[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            datums[i] = this.get(i);
        }
        return datums;
    }

    public Tuple clone() throws CloneNotSupportedException {
        LazyTuple lazyTuple = (LazyTuple)super.clone();
        lazyTuple.values = this.getValues();
        lazyTuple.textBytes = new byte[this.size()][];
        return lazyTuple;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tuple) {
            Tuple other = (Tuple)obj;
            return Arrays.equals(this.getValues(), other.getValues());
        }
        return false;
    }
}

