/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import com.google.common.base.Preconditions;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.exception.UnsupportedException;
import org.apache.tajo.storage.Tuple;

public class FrameTuple
implements Tuple,
Cloneable {
    private int size;
    private int leftSize;
    private Tuple left;
    private Tuple right;

    public FrameTuple() {
    }

    public FrameTuple(Tuple left, Tuple right) {
        this.set(left, right);
    }

    public void set(Tuple left, Tuple right) {
        this.size = left.size() + right.size();
        this.left = left;
        this.leftSize = left.size();
        this.right = right;
    }

    public int size() {
        return this.size;
    }

    public boolean contains(int fieldId) {
        Preconditions.checkArgument((fieldId < this.size ? 1 : 0) != 0, (Object)("Out of field access: " + fieldId));
        if (fieldId < this.leftSize) {
            return this.left.contains(fieldId);
        }
        return this.right.contains(fieldId - this.leftSize);
    }

    public boolean isNull(int fieldid) {
        return this.get(fieldid).isNull();
    }

    public boolean isNotNull(int fieldid) {
        return !this.isNull(fieldid);
    }

    public void clear() {
        throw new UnsupportedException();
    }

    public void put(int fieldId, Datum value) {
        throw new UnsupportedException();
    }

    public void put(int fieldId, Datum[] values) {
        throw new UnsupportedException();
    }

    public void put(int fieldId, Tuple tuple) {
        throw new UnsupportedException();
    }

    public void setOffset(long offset) {
        throw new UnsupportedException();
    }

    public long getOffset() {
        throw new UnsupportedException();
    }

    public void put(Datum[] values) {
        throw new UnsupportedException();
    }

    public Datum get(int fieldId) {
        Preconditions.checkArgument((fieldId < this.size ? 1 : 0) != 0, (Object)("Out of field access: " + fieldId));
        if (fieldId < this.leftSize) {
            return this.left.get(fieldId);
        }
        return this.right.get(fieldId - this.leftSize);
    }

    public boolean getBool(int fieldId) {
        return this.get(fieldId).asBool();
    }

    public byte getByte(int fieldId) {
        return this.get(fieldId).asByte();
    }

    public char getChar(int fieldId) {
        return this.get(fieldId).asChar();
    }

    public byte[] getBytes(int fieldId) {
        return this.get(fieldId).asByteArray();
    }

    public short getInt2(int fieldId) {
        return this.get(fieldId).asInt2();
    }

    public int getInt4(int fieldId) {
        return this.get(fieldId).asInt4();
    }

    public long getInt8(int fieldId) {
        return this.get(fieldId).asInt8();
    }

    public float getFloat4(int fieldId) {
        return this.get(fieldId).asFloat4();
    }

    public double getFloat8(int fieldId) {
        return this.get(fieldId).asFloat8();
    }

    public String getText(int fieldId) {
        return this.get(fieldId).asChars();
    }

    public ProtobufDatum getProtobufDatum(int fieldId) {
        return (ProtobufDatum)this.get(fieldId);
    }

    public IntervalDatum getInterval(int fieldId) {
        return (IntervalDatum)this.get(fieldId);
    }

    public char[] getUnicodeChars(int fieldId) {
        return this.get(fieldId).asUnicodeChars();
    }

    public Tuple clone() throws CloneNotSupportedException {
        FrameTuple frameTuple = (FrameTuple)super.clone();
        frameTuple.set(this.left.clone(), this.right.clone());
        return frameTuple;
    }

    public Datum[] getValues() {
        throw new UnsupportedException();
    }

    public String toString() {
        boolean first = true;
        StringBuilder str = new StringBuilder();
        str.append("(");
        for (int i = 0; i < this.size(); ++i) {
            if (!this.contains(i)) continue;
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(i).append("=>").append(this.get(i));
        }
        str.append(")");
        return str.toString();
    }
}

