/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.tajo.storage.DiskDeviceInfo;
import org.apache.tajo.storage.DiskMountInfo;

public class DiskUtil {
    static String UNIX_DISK_DEVICE_PATH = "/proc/partitions";

    private static OSType getOSType() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows") && (osName.contains("XP") || osName.contains("2003") || osName.contains("Vista") || osName.contains("Windows_7") || osName.contains("Windows 7") || osName.contains("Windows7"))) {
            return OSType.OS_TYPE_WINXP;
        }
        if (osName.contains("SunOS") || osName.contains("Solaris")) {
            return OSType.OS_TYPE_SOLARIS;
        }
        if (osName.contains("Mac")) {
            return OSType.OS_TYPE_MAC;
        }
        return OSType.OS_TYPE_UNIX;
    }

    public static List<DiskDeviceInfo> getDiskDeviceInfos() throws IOException {
        List<DiskDeviceInfo> deviceInfos;
        if (DiskUtil.getOSType() == OSType.OS_TYPE_UNIX) {
            deviceInfos = DiskUtil.getUnixDiskDeviceInfos();
            DiskUtil.setDeviceMountInfo(deviceInfos);
        } else {
            deviceInfos = DiskUtil.getDefaultDiskDeviceInfos();
        }
        return deviceInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DiskDeviceInfo> getUnixDiskDeviceInfos() {
        ArrayList<DiskDeviceInfo> infos = new ArrayList<DiskDeviceInfo>();
        File file = new File(UNIX_DISK_DEVICE_PATH);
        if (!file.exists()) {
            System.out.println("No partition file:" + file.getAbsolutePath());
            return DiskUtil.getDefaultDiskDeviceInfos();
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(UNIX_DISK_DEVICE_PATH)));
            String line = null;
            int count = 0;
            TreeSet<String> deviceNames = new TreeSet<String>();
            while ((line = reader.readLine()) != null) {
                String[] tokens;
                if (count > 0 && !line.trim().isEmpty() && (tokens = line.trim().split(" +")).length == 4) {
                    String deviceName = DiskUtil.getDiskDeviceName(tokens[3]);
                    deviceNames.add(deviceName);
                }
                ++count;
            }
            int id = 0;
            for (String eachDeviceName : deviceNames) {
                DiskDeviceInfo diskDeviceInfo = new DiskDeviceInfo(id++);
                diskDeviceInfo.setName(eachDeviceName);
                infos.add(diskDeviceInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return infos;
    }

    private static String getDiskDeviceName(String partitionName) {
        byte[] bytes = partitionName.getBytes();
        byte[] result = new byte[bytes.length];
        int length = 0;
        int i = 0;
        while (i < bytes.length && (bytes[i] < 48 || bytes[i] > 57)) {
            result[i] = bytes[i];
            ++i;
            ++length;
        }
        return new String(result, 0, length);
    }

    public static List<DiskDeviceInfo> getDefaultDiskDeviceInfos() {
        DiskDeviceInfo diskDeviceInfo = new DiskDeviceInfo(0);
        diskDeviceInfo.setName("default");
        ArrayList<DiskDeviceInfo> infos = new ArrayList<DiskDeviceInfo>();
        infos.add(diskDeviceInfo);
        return infos;
    }

    private static void setDeviceMountInfo(List<DiskDeviceInfo> deviceInfos) throws IOException {
        HashMap<String, DiskDeviceInfo> deviceMap = new HashMap<String, DiskDeviceInfo>();
        for (DiskDeviceInfo eachDevice : deviceInfos) {
            deviceMap.put(eachDevice.getName(), eachDevice);
        }
        BufferedReader mountOutput = null;
        try {
            String line;
            Process mountProcess = Runtime.getRuntime().exec("mount");
            mountOutput = new BufferedReader(new InputStreamReader(mountProcess.getInputStream()));
            while ((line = mountOutput.readLine()) != null) {
                int indexStart = line.indexOf(" on /");
                int indexEnd = line.indexOf(" ", indexStart + 4);
                String deviceName = line.substring(0, indexStart).trim();
                String[] deviceNameTokens = deviceName.split("/");
                if (deviceNameTokens.length != 3 || !"dev".equals(deviceNameTokens[1])) continue;
                String realDeviceName = DiskUtil.getDiskDeviceName(deviceNameTokens[2]);
                String mountPath = new File(line.substring(indexStart + 4, indexEnd)).getAbsolutePath();
                DiskDeviceInfo diskDeviceInfo = (DiskDeviceInfo)deviceMap.get(realDeviceName);
                if (diskDeviceInfo == null) continue;
                diskDeviceInfo.addMountPath(new DiskMountInfo(diskDeviceInfo.getId(), mountPath));
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (mountOutput != null) {
                mountOutput.close();
            }
        }
    }

    public static int getDataNodeStorageSize() {
        return DiskUtil.getStorageDirs().size();
    }

    public static List<URI> getStorageDirs() {
        HdfsConfiguration conf = new HdfsConfiguration();
        Collection dirNames = conf.getTrimmedStringCollection("dfs.datanode.data.dir");
        return Util.stringCollectionAsURIs((Collection)dirNames);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("/dev/sde1".split("/").length);
        for (String eachToken : "/dev/sde1".split("/")) {
            System.out.println(eachToken);
        }
    }

    public static enum OSType {
        OS_TYPE_UNIX,
        OS_TYPE_WINXP,
        OS_TYPE_SOLARIS,
        OS_TYPE_MAC;

    }
}

