/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import com.google.common.base.Objects;

public class DiskMountInfo
implements Comparable<DiskMountInfo> {
    private String mountPath;
    private long capacity;
    private long used;
    private int deviceId;

    public DiskMountInfo(int deviceId, String mountPath) {
        this.mountPath = mountPath;
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public long getUsed() {
        return this.used;
    }

    public void setUsed(long used) {
        this.used = used;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DiskMountInfo)) {
            return false;
        }
        return this.compareTo((DiskMountInfo)obj) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mountPath});
    }

    @Override
    public int compareTo(DiskMountInfo other) {
        int path2Length;
        int path2Depth;
        String path1 = this.mountPath;
        String path2 = other.mountPath;
        int path1Depth = "/".equals(path1) ? 0 : path1.split("/", -1).length - 1;
        int n = path2Depth = "/".equals(path2) ? 0 : path2.split("/", -1).length - 1;
        if (path1Depth > path2Depth) {
            return -1;
        }
        if (path1Depth < path2Depth) {
            return 1;
        }
        int path1Length = path1.length();
        if (path1Length < (path2Length = path2.length())) {
            return 1;
        }
        if (path1Length > path2Length) {
            return -1;
        }
        return path1.compareTo(path2);
    }
}

