/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.io.IOUtils;

public class ByteBufInputChannel
extends AbstractInterruptibleChannel
implements ScatteringByteChannel {
    ByteBufferReadable byteBufferReadable;
    ReadableByteChannel channel;
    InputStream inputStream;

    public ByteBufInputChannel(InputStream inputStream) {
        if (inputStream instanceof DFSInputStream && inputStream instanceof ByteBufferReadable) {
            this.byteBufferReadable = (ByteBufferReadable)inputStream;
        } else {
            this.channel = Channels.newChannel(inputStream);
        }
        this.inputStream = inputStream;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long read(ByteBuffer[] dsts) {
        return this.read(dsts, 0, dsts.length);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.byteBufferReadable != null) {
            return this.byteBufferReadable.read(dst);
        }
        return this.channel.read(dst);
    }

    @Override
    protected void implCloseChannel() throws IOException {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.channel, this.inputStream});
    }
}

