/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import org.apache.hadoop.classification.InterfaceStability;

public class BufferPool {
    private static final PooledByteBufAllocator allocator = new PooledByteBufAllocator(PlatformDependent.directBufferPreferred());

    private BufferPool() {
    }

    public static long maxDirectMemory() {
        return PlatformDependent.maxDirectMemory();
    }

    public static synchronized ByteBuf directBuffer(int size) {
        return allocator.directBuffer(size);
    }

    public static ByteBuf directBuffer(int size, int max) {
        return allocator.directBuffer(size, max);
    }

    @InterfaceStability.Unstable
    public static void forceRelease(ByteBuf buf) {
        buf.release(buf.refCnt());
    }

    public static void ensureWritable(ByteBuf buf, int minWritableBytes) {
        buf.ensureWritable(minWritableBytes);
    }
}

