/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.datum.ProtobufDatumFactory;
import org.apache.tajo.storage.SerializerDeserializer;
import org.apache.tajo.util.Bytes;

@Deprecated
public class BinarySerializerDeserializer
implements SerializerDeserializer {
    static final byte[] INVALID_UTF__SINGLE_BYTE = new byte[]{(byte)Integer.parseInt("10111111", 2)};
    private byte[] shortBytes = new byte[2];
    private byte[] floatBytes = new byte[4];
    private byte[] doubleBytes = new byte[8];
    private byte[] vLongBytes = new byte[9];

    @Override
    public int serialize(Column col, Datum datum, OutputStream out, byte[] nullCharacters) throws IOException {
        int length = 0;
        if (datum == null || datum instanceof NullDatum) {
            return 0;
        }
        switch (col.getDataType().getType()) {
            case BOOLEAN: 
            case BIT: 
            case CHAR: {
                byte[] bytes = datum.asByteArray();
                length = bytes.length;
                out.write(bytes, 0, length);
                break;
            }
            case INT2: {
                length = this.writeShort(out, datum.asInt2());
                break;
            }
            case INT4: {
                length = this.writeVLong(out, datum.asInt4());
                break;
            }
            case INT8: {
                length = this.writeVLong(out, datum.asInt8());
                break;
            }
            case FLOAT4: {
                length = this.writeFloat(out, datum.asFloat4());
                break;
            }
            case FLOAT8: {
                length = this.writeDouble(out, datum.asFloat8());
                break;
            }
            case TEXT: {
                byte[] bytes = datum.asTextBytes();
                length = datum.size();
                if (length == 0) {
                    bytes = INVALID_UTF__SINGLE_BYTE;
                    length = INVALID_UTF__SINGLE_BYTE.length;
                }
                out.write(bytes, 0, bytes.length);
                break;
            }
            case BLOB: 
            case INET4: 
            case INET6: {
                byte[] bytes = datum.asByteArray();
                length = bytes.length;
                out.write(bytes, 0, length);
                break;
            }
            case PROTOBUF: {
                ProtobufDatum protobufDatum = (ProtobufDatum)datum;
                byte[] bytes = protobufDatum.asByteArray();
                length = bytes.length;
                out.write(bytes, 0, length);
                break;
            }
            case NULL_TYPE: {
                break;
            }
            default: {
                throw new IOException("Does not support type");
            }
        }
        return length;
    }

    @Override
    public Datum deserialize(Column col, byte[] bytes, int offset, int length, byte[] nullCharacters) throws IOException {
        NullDatum datum;
        if (length == 0) {
            return NullDatum.get();
        }
        switch (col.getDataType().getType()) {
            case BOOLEAN: {
                datum = DatumFactory.createBool((byte)bytes[offset]);
                break;
            }
            case BIT: {
                datum = DatumFactory.createBit((byte)bytes[offset]);
                break;
            }
            case CHAR: {
                byte[] chars = new byte[length];
                System.arraycopy(bytes, offset, chars, 0, length);
                datum = DatumFactory.createChar((byte[])chars);
                break;
            }
            case INT2: {
                datum = DatumFactory.createInt2((short)Bytes.toShort((byte[])bytes, (int)offset, (int)length));
                break;
            }
            case INT4: {
                datum = DatumFactory.createInt4((int)((int)Bytes.readVLong((byte[])bytes, (int)offset)));
                break;
            }
            case INT8: {
                datum = DatumFactory.createInt8((long)Bytes.readVLong((byte[])bytes, (int)offset));
                break;
            }
            case FLOAT4: {
                datum = DatumFactory.createFloat4((float)this.toFloat(bytes, offset, length));
                break;
            }
            case FLOAT8: {
                datum = DatumFactory.createFloat8((double)this.toDouble(bytes, offset, length));
                break;
            }
            case TEXT: {
                byte[] chars = new byte[length];
                System.arraycopy(bytes, offset, chars, 0, length);
                if (Bytes.equals((byte[])INVALID_UTF__SINGLE_BYTE, (byte[])chars)) {
                    datum = DatumFactory.createText((byte[])new byte[0]);
                    break;
                }
                datum = DatumFactory.createText((byte[])chars);
                break;
            }
            case PROTOBUF: {
                ProtobufDatumFactory factory = ProtobufDatumFactory.get((String)col.getDataType().getCode());
                Message.Builder builder = factory.newBuilder();
                builder.mergeFrom(bytes, offset, length);
                datum = factory.createDatum(builder);
                break;
            }
            case INET4: {
                datum = DatumFactory.createInet4((byte[])bytes, (int)offset, (int)length);
                break;
            }
            case BLOB: {
                datum = DatumFactory.createBlob((byte[])bytes, (int)offset, (int)length);
                break;
            }
            default: {
                datum = NullDatum.get();
            }
        }
        return datum;
    }

    public int writeShort(OutputStream out, short val) throws IOException {
        this.shortBytes[0] = (byte)(val >> 8);
        this.shortBytes[1] = (byte)val;
        out.write(this.shortBytes, 0, 2);
        return 2;
    }

    public float toFloat(byte[] bytes, int offset, int length) {
        Preconditions.checkArgument((length == 4 ? 1 : 0) != 0);
        int val = ((bytes[offset] & 0xFF) << 24) + ((bytes[offset + 1] & 0xFF) << 16) + ((bytes[offset + 2] & 0xFF) << 8) + (bytes[offset + 3] & 0xFF);
        return Float.intBitsToFloat(val);
    }

    public int writeFloat(OutputStream out, float f) throws IOException {
        int val = Float.floatToIntBits(f);
        this.floatBytes[0] = (byte)(val >> 24);
        this.floatBytes[1] = (byte)(val >> 16);
        this.floatBytes[2] = (byte)(val >> 8);
        this.floatBytes[3] = (byte)val;
        out.write(this.floatBytes, 0, 4);
        return this.floatBytes.length;
    }

    public double toDouble(byte[] bytes, int offset, int length) {
        Preconditions.checkArgument((length == 8 ? 1 : 0) != 0);
        long val = ((long)(bytes[offset] & 0xFF) << 56) + ((long)(bytes[offset + 1] & 0xFF) << 48) + ((long)(bytes[offset + 2] & 0xFF) << 40) + ((long)(bytes[offset + 3] & 0xFF) << 32) + ((long)(bytes[offset + 4] & 0xFF) << 24) + ((long)(bytes[offset + 5] & 0xFF) << 16) + ((long)(bytes[offset + 6] & 0xFF) << 8) + (long)(bytes[offset + 7] & 0xFF);
        return Double.longBitsToDouble(val);
    }

    public int writeDouble(OutputStream out, double d) throws IOException {
        long val = Double.doubleToLongBits(d);
        this.doubleBytes[0] = (byte)(val >> 56);
        this.doubleBytes[1] = (byte)(val >> 48);
        this.doubleBytes[2] = (byte)(val >> 40);
        this.doubleBytes[3] = (byte)(val >> 32);
        this.doubleBytes[4] = (byte)(val >> 24);
        this.doubleBytes[5] = (byte)(val >> 16);
        this.doubleBytes[6] = (byte)(val >> 8);
        this.doubleBytes[7] = (byte)val;
        out.write(this.doubleBytes, 0, 8);
        return this.doubleBytes.length;
    }

    public static int writeVLongToByteArray(byte[] bytes, int offset, long l) {
        if (l >= -112L && l <= 127L) {
            bytes[offset] = (byte)l;
            return 1;
        }
        int len = -112;
        if (l < 0L) {
            l ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = l;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        bytes[offset++] = (byte)len;
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            bytes[offset++] = (byte)((l & 255L << shiftbits) >> shiftbits);
        }
        return 1 + len;
    }

    public int writeVLong(OutputStream out, long l) throws IOException {
        int len = BinarySerializerDeserializer.writeVLongToByteArray(this.vLongBytes, 0, l);
        out.write(this.vLongBytes, 0, len);
        return len;
    }
}

