/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SortSpec;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.common.ProtoObject;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.index.IndexProtos;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.storage.TupleComparator;

public class BaseTupleComparator
extends TupleComparator
implements ProtoObject<IndexProtos.TupleComparatorProto> {
    private final Schema schema;
    private final SortSpec[] sortSpecs;
    private final int[] sortKeyIds;
    private final boolean[] asc;
    private final boolean[] nullFirsts;
    private Datum left;
    private Datum right;
    private int compVal;

    public BaseTupleComparator(Schema schema, SortSpec[] sortKeys) {
        Preconditions.checkArgument((sortKeys.length > 0 ? 1 : 0) != 0, (Object)"At least one sort key must be specified.");
        this.schema = schema;
        this.sortSpecs = sortKeys;
        this.sortKeyIds = new int[sortKeys.length];
        this.asc = new boolean[sortKeys.length];
        this.nullFirsts = new boolean[sortKeys.length];
        for (int i = 0; i < sortKeys.length; ++i) {
            this.sortKeyIds[i] = sortKeys[i].getSortKey().hasQualifier() ? schema.getColumnId(sortKeys[i].getSortKey().getQualifiedName()) : schema.getColumnIdByName(sortKeys[i].getSortKey().getSimpleName());
            this.asc[i] = sortKeys[i].isAscending();
            this.nullFirsts[i] = sortKeys[i].isNullFirst();
        }
    }

    public BaseTupleComparator(IndexProtos.TupleComparatorProto proto) {
        int i;
        this.schema = new Schema(proto.getSchema());
        this.sortSpecs = new SortSpec[proto.getSortSpecsCount()];
        for (i = 0; i < proto.getSortSpecsCount(); ++i) {
            this.sortSpecs[i] = new SortSpec(proto.getSortSpecs(i));
        }
        this.sortKeyIds = new int[proto.getCompSpecsCount()];
        this.asc = new boolean[proto.getCompSpecsCount()];
        this.nullFirsts = new boolean[proto.getCompSpecsCount()];
        for (i = 0; i < proto.getCompSpecsCount(); ++i) {
            CatalogProtos.TupleComparatorSpecProto sortSepcProto = proto.getCompSpecs(i);
            this.sortKeyIds[i] = sortSepcProto.getColumnId();
            this.asc[i] = sortSepcProto.getAscending();
            this.nullFirsts[i] = sortSepcProto.getNullFirst();
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public SortSpec[] getSortSpecs() {
        return this.sortSpecs;
    }

    public int[] getSortKeyIds() {
        return this.sortKeyIds;
    }

    @Override
    public boolean isAscendingFirstKey() {
        return this.asc[0];
    }

    @Override
    public int compare(Tuple tuple1, Tuple tuple2) {
        for (int i = 0; i < this.sortKeyIds.length; ++i) {
            this.left = tuple1.get(this.sortKeyIds[i]);
            this.right = tuple2.get(this.sortKeyIds[i]);
            if (this.left.isNull() || this.right.isNull()) {
                if (!this.left.equals(this.right)) {
                    if (this.left.isNull()) {
                        this.compVal = 1;
                    } else if (this.right.isNull()) {
                        this.compVal = -1;
                    }
                    if (this.compVal != 0 && (this.nullFirsts[i] && this.asc[i] || !this.nullFirsts[i] && !this.asc[i])) {
                        this.compVal *= -1;
                    }
                } else {
                    this.compVal = 0;
                }
            } else {
                this.compVal = this.asc[i] ? this.left.compareTo(this.right) : this.right.compareTo(this.left);
            }
            if (this.compVal >= 0 && this.compVal <= 0) continue;
            return this.compVal;
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sortKeyIds});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BaseTupleComparator) {
            BaseTupleComparator other = (BaseTupleComparator)obj;
            if (this.sortKeyIds.length != other.sortKeyIds.length) {
                return false;
            }
            for (int i = 0; i < this.sortKeyIds.length; ++i) {
                if (this.sortKeyIds[i] == other.sortKeyIds[i] && this.asc[i] == other.asc[i] && this.nullFirsts[i] == other.nullFirsts[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public IndexProtos.TupleComparatorProto getProto() {
        IndexProtos.TupleComparatorProto.Builder builder = IndexProtos.TupleComparatorProto.newBuilder();
        builder.setSchema(this.schema.getProto());
        for (int i = 0; i < this.sortSpecs.length; ++i) {
            builder.addSortSpecs(this.sortSpecs[i].getProto());
        }
        for (int i = 0; i < this.sortKeyIds.length; ++i) {
            CatalogProtos.TupleComparatorSpecProto.Builder sortSpecBuilder = CatalogProtos.TupleComparatorSpecProto.newBuilder();
            sortSpecBuilder.setColumnId(this.sortKeyIds[i]);
            sortSpecBuilder.setAscending(this.asc[i]);
            sortSpecBuilder.setNullFirst(this.nullFirsts[i]);
            builder.addCompSpecs(sortSpecBuilder);
        }
        return builder.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        for (int i = 0; i < this.sortKeyIds.length; ++i) {
            sb.append(prefix).append("SortKeyId=").append(this.sortKeyIds[i]).append(",Asc=").append(this.asc[i]).append(",NullFirst=").append(this.nullFirsts[i]);
            prefix = " ,";
        }
        return sb.toString();
    }
}

