/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.rpc;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.tajo.rpc.NettyClientBase;
import org.apache.tajo.rpc.RemoteException;
import org.apache.tajo.rpc.RpcConnectionPool;

public abstract class ServerCallable<T> {
    protected InetSocketAddress addr;
    protected long startTime;
    protected long endTime;
    protected Class protocol;
    protected boolean asyncMode;
    protected boolean closeConn;
    protected RpcConnectionPool connPool;
    boolean abort = false;

    public abstract T call(NettyClientBase var1) throws Exception;

    public ServerCallable(RpcConnectionPool connPool, InetSocketAddress addr, Class protocol, boolean asyncMode) {
        this(connPool, addr, protocol, asyncMode, false);
    }

    public ServerCallable(RpcConnectionPool connPool, InetSocketAddress addr, Class protocol, boolean asyncMode, boolean closeConn) {
        this.connPool = connPool;
        this.addr = addr;
        this.protocol = protocol;
        this.asyncMode = asyncMode;
        this.closeConn = closeConn;
    }

    public void beforeCall() {
        this.startTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void afterCall() {
        this.endTime = System.currentTimeMillis();
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void abort() {
        this.abort = true;
    }

    /*
     * Loose catch block
     */
    public T withRetries() throws ServiceException {
        long pause = 500L;
        int numRetries = 3;
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (int tries = 0; tries < 3; ++tries) {
            T t;
            block17: {
                NettyClientBase client = null;
                try {
                    this.beforeCall();
                    if (this.addr != null) {
                        client = this.connPool.getConnection(this.addr, this.protocol, this.asyncMode);
                    }
                    t = this.call(client);
                    this.afterCall();
                    if (this.closeConn) {
                        this.connPool.closeConnection(client);
                        break block17;
                    }
                    this.connPool.releaseConnection(client);
                }
                catch (IOException ioe) {
                    exceptions.add(ioe);
                    if (this.abort) {
                        throw new ServiceException(ioe.getMessage(), (Throwable)ioe);
                    }
                    if (tries == 2) {
                        throw new ServiceException("Giving up after tries=" + tries, (Throwable)ioe);
                    }
                    this.afterCall();
                    if (this.closeConn) {
                        this.connPool.closeConnection(client);
                    } else {
                        this.connPool.releaseConnection(client);
                    }
                }
                catch (Throwable t2) {
                    throw new ServiceException(t2);
                    {
                        catch (Throwable throwable) {
                            this.afterCall();
                            if (this.closeConn) {
                                this.connPool.closeConnection(client);
                            } else {
                                this.connPool.releaseConnection(client);
                            }
                            throw throwable;
                        }
                    }
                }
            }
            return t;
            try {
                Thread.sleep(500L * (long)(tries + 1));
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ServiceException("Giving up after tries=" + tries, (Throwable)e);
            }
        }
        return null;
    }

    public T withoutRetries() throws IOException, RuntimeException {
        T t;
        block8: {
            NettyClientBase client = null;
            try {
                this.beforeCall();
                client = this.connPool.getConnection(this.addr, this.protocol, this.asyncMode);
                t = this.call(client);
                this.afterCall();
                if (this.closeConn) {
                    this.connPool.closeConnection(client);
                    break block8;
                }
                this.connPool.releaseConnection(client);
            }
            catch (Throwable t2) {
                try {
                    Throwable t22 = ServerCallable.translateException(t2);
                    if (t22 instanceof IOException) {
                        throw (IOException)t22;
                    }
                    throw new RuntimeException(t22);
                }
                catch (Throwable throwable) {
                    this.afterCall();
                    if (this.closeConn) {
                        this.connPool.closeConnection(client);
                    } else {
                        this.connPool.releaseConnection(client);
                    }
                    throw throwable;
                }
            }
        }
        return t;
    }

    private static Throwable translateException(Throwable t) throws IOException {
        if (t instanceof UndeclaredThrowableException) {
            t = t.getCause();
        }
        if (t instanceof RemoteException && t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }
}

