/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.rpc;

import com.google.common.base.Objects;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.conf.TajoConf;
import org.apache.tajo.rpc.AsyncRpcClient;
import org.apache.tajo.rpc.BlockingRpcClient;
import org.apache.tajo.rpc.NettyClientBase;
import org.apache.tajo.rpc.RpcChannelFactory;
import org.jboss.netty.channel.ConnectTimeoutException;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.logging.CommonsLoggerFactory;
import org.jboss.netty.logging.InternalLoggerFactory;

public class RpcConnectionPool {
    private static final Log LOG = LogFactory.getLog(RpcConnectionPool.class);
    private ConcurrentMap<RpcConnectionKey, NettyClientBase> connections = new ConcurrentHashMap<RpcConnectionKey, NettyClientBase>();
    private ChannelGroup accepted = new DefaultChannelGroup();
    private static RpcConnectionPool instance;
    private final ClientSocketChannelFactory channelFactory;
    private final TajoConf conf;
    public static final int RPC_RETRIES = 3;

    private RpcConnectionPool(TajoConf conf, ClientSocketChannelFactory channelFactory) {
        this.conf = conf;
        this.channelFactory = channelFactory;
    }

    public static synchronized RpcConnectionPool getPool(TajoConf conf) {
        if (instance == null) {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new CommonsLoggerFactory());
            instance = new RpcConnectionPool(conf, RpcChannelFactory.getSharedClientChannelFactory());
        }
        return instance;
    }

    public static synchronized RpcConnectionPool newPool(TajoConf conf, String poolName, int workerNum) {
        return new RpcConnectionPool(conf, RpcChannelFactory.createClientChannelFactory(poolName, workerNum));
    }

    private NettyClientBase makeConnection(RpcConnectionKey rpcConnectionKey) throws NoSuchMethodException, ClassNotFoundException, ConnectTimeoutException {
        NettyClientBase client = rpcConnectionKey.asyncMode ? new AsyncRpcClient(rpcConnectionKey.protocolClass, rpcConnectionKey.addr, this.channelFactory, 3) : new BlockingRpcClient(rpcConnectionKey.protocolClass, rpcConnectionKey.addr, this.channelFactory, 3);
        this.accepted.add((Object)client.getChannel());
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NettyClientBase getConnection(InetSocketAddress addr, Class protocolClass, boolean asyncMode) throws NoSuchMethodException, ClassNotFoundException, ConnectTimeoutException {
        RpcConnectionKey key = new RpcConnectionKey(addr, protocolClass, asyncMode);
        NettyClientBase client = (NettyClientBase)this.connections.get(key);
        if (client == null) {
            boolean added;
            ConcurrentMap<RpcConnectionKey, NettyClientBase> concurrentMap = this.connections;
            synchronized (concurrentMap) {
                client = this.makeConnection(key);
                this.connections.put(key, client);
                added = true;
            }
            if (!added) {
                client.close();
                client = (NettyClientBase)this.connections.get(key);
            }
        }
        if (!client.getChannel().isOpen() || !client.getChannel().isConnected()) {
            LOG.warn((Object)("Try to reconnect : " + addr));
            client.connect(addr);
        }
        return client;
    }

    public void releaseConnection(NettyClientBase client) {
        if (client == null) {
            return;
        }
        try {
            if (!client.getChannel().isOpen()) {
                this.connections.remove(client.getKey());
                client.close();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Current Connections [" + this.connections.size() + "] Accepted: " + this.accepted.size()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can't close connection:" + client.getKey() + ":" + e.getMessage()), (Throwable)e);
        }
    }

    public void closeConnection(NettyClientBase client) {
        if (client == null) {
            return;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Close connection [" + client.getKey() + "]"));
            }
            this.connections.remove(client.getKey());
            client.close();
        }
        catch (Exception e) {
            LOG.error((Object)("Can't close connection:" + client.getKey() + ":" + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Pool Closed");
        }
        ConcurrentMap<RpcConnectionKey, NettyClientBase> concurrentMap = this.connections;
        synchronized (concurrentMap) {
            for (NettyClientBase eachClient : this.connections.values()) {
                try {
                    eachClient.close();
                }
                catch (Exception e) {
                    LOG.error((Object)"close client pool error", (Throwable)e);
                }
            }
        }
        this.connections.clear();
        try {
            this.accepted.close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            LOG.error((Object)t);
        }
    }

    public synchronized void shutdown() {
        this.close();
        if (this.channelFactory != null) {
            this.channelFactory.releaseExternalResources();
        }
    }

    static class RpcConnectionKey {
        final InetSocketAddress addr;
        final Class protocolClass;
        final boolean asyncMode;

        public RpcConnectionKey(InetSocketAddress addr, Class protocolClass, boolean asyncMode) {
            this.addr = addr;
            this.protocolClass = protocolClass;
            this.asyncMode = asyncMode;
        }

        public String toString() {
            return "[" + this.protocolClass + "] " + this.addr + "," + this.asyncMode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RpcConnectionKey)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.addr, this.asyncMode});
        }
    }
}

