/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.rpc;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.conf.TajoConf;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioClientBossPool;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerBossPool;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.Timer;

public final class RpcChannelFactory {
    private static final Log LOG = LogFactory.getLog(RpcChannelFactory.class);
    private static ClientSocketChannelFactory factory;
    private static AtomicInteger clientCount;
    private static AtomicInteger serverCount;

    private RpcChannelFactory() {
    }

    public static synchronized ClientSocketChannelFactory getSharedClientChannelFactory() {
        if (factory == null) {
            TajoConf conf = new TajoConf();
            int workerNum = conf.getIntVar(TajoConf.ConfVars.INTERNAL_RPC_CLIENT_WORKER_THREAD_NUM);
            factory = RpcChannelFactory.createClientChannelFactory("Internal-Client", workerNum);
        }
        return factory;
    }

    public static synchronized ClientSocketChannelFactory createClientChannelFactory(String name, int workerNum) {
        name = name + "-" + clientCount.incrementAndGet();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Create " + name + " ClientSocketChannelFactory. Worker:" + workerNum));
        }
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        ThreadFactory bossFactory = builder.setNameFormat(name + " Boss #%d").build();
        ThreadFactory workerFactory = builder.setNameFormat(name + " Worker #%d").build();
        NioClientBossPool bossPool = new NioClientBossPool((Executor)Executors.newCachedThreadPool(bossFactory), 1, (Timer)new HashedWheelTimer(), ThreadNameDeterminer.CURRENT);
        NioWorkerPool workerPool = new NioWorkerPool((Executor)Executors.newCachedThreadPool(workerFactory), workerNum, ThreadNameDeterminer.CURRENT);
        return new NioClientSocketChannelFactory((BossPool)bossPool, (WorkerPool)workerPool);
    }

    public static synchronized ServerSocketChannelFactory createServerChannelFactory(String name, int workerNum) {
        name = name + "-" + serverCount.incrementAndGet();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Create " + name + " ServerSocketChannelFactory. Worker:" + workerNum));
        }
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        ThreadFactory bossFactory = builder.setNameFormat(name + " Server Boss #%d").build();
        ThreadFactory workerFactory = builder.setNameFormat(name + " Server Worker #%d").build();
        NioServerBossPool bossPool = new NioServerBossPool((Executor)Executors.newCachedThreadPool(bossFactory), 1, ThreadNameDeterminer.CURRENT);
        NioWorkerPool workerPool = new NioWorkerPool((Executor)Executors.newCachedThreadPool(workerFactory), workerNum, ThreadNameDeterminer.CURRENT);
        return new NioServerSocketChannelFactory((BossPool)bossPool, (WorkerPool)workerPool);
    }

    public static synchronized void shutdown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Shutdown Shared RPC Pool");
        }
        if (factory != null) {
            factory.releaseExternalResources();
        }
        factory = null;
    }

    static {
        clientCount = new AtomicInteger(0);
        serverCount = new AtomicInteger(0);
    }
}

