/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.rpc;

import java.io.IOException;
import java.util.Date;
import java.util.List;

public class RetriesExhaustedException
extends RuntimeException {
    private static final long serialVersionUID = 1876775844L;

    public RetriesExhaustedException(String msg) {
        super(msg);
    }

    public RetriesExhaustedException(String msg, IOException e) {
        super(msg, e);
    }

    public RetriesExhaustedException(String callableVitals, int numTries, List<Throwable> exceptions) {
        super(RetriesExhaustedException.getMessage(callableVitals, numTries, exceptions));
    }

    public RetriesExhaustedException(int numTries, List<Throwable> exceptions) {
        super(RetriesExhaustedException.getMessage(numTries, exceptions));
    }

    private static String getMessage(String callableVitals, int numTries, List<Throwable> exceptions) {
        StringBuilder buffer = new StringBuilder("Failed contacting ");
        buffer.append(callableVitals);
        buffer.append(" after ");
        buffer.append(numTries + 1);
        buffer.append(" attempts.\nExceptions:\n");
        for (Throwable t : exceptions) {
            buffer.append(t.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private static String getMessage(int numTries, List<Throwable> exceptions) {
        StringBuilder buffer = new StringBuilder("Failed after attempts=");
        buffer.append(numTries + 1);
        buffer.append(", exceptions:\n");
        for (Throwable t : exceptions) {
            buffer.append(t.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static class ThrowableWithExtraContext {
        private final Throwable t;
        private final long when;
        private final String extras;

        public ThrowableWithExtraContext(Throwable t, long when, String extras) {
            this.t = t;
            this.when = when;
            this.extras = extras;
        }

        public String toString() {
            return new Date(this.when).toString() + ", " + this.extras + ", " + this.t.toString();
        }
    }
}

