/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.rpc;

import com.google.protobuf.Descriptors;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tajo.rpc.RemoteException;
import org.apache.tajo.rpc.RpcProtos;

public class RemoteCallException
extends RemoteException {
    private int seqId;
    private String originExceptionClass;

    public RemoteCallException(int seqId, Descriptors.MethodDescriptor methodDesc, Throwable t) {
        super("Remote call error occurs when " + methodDesc.getFullName() + "is called:", t);
        this.seqId = seqId;
        if (t != null) {
            this.originExceptionClass = t.getClass().getCanonicalName();
        }
    }

    public RemoteCallException(int seqId, Throwable t) {
        super(t);
        this.seqId = seqId;
        if (t != null) {
            this.originExceptionClass = t.getClass().getCanonicalName();
        }
    }

    public RpcProtos.RpcResponse getResponse() {
        RpcProtos.RpcResponse.Builder builder = RpcProtos.RpcResponse.newBuilder();
        builder.setId(this.seqId);
        builder.setErrorMessage(this.getCause().getMessage());
        builder.setErrorTrace(RemoteCallException.getStackTraceString(this.getCause()));
        builder.setErrorClass(this.originExceptionClass);
        return builder.build();
    }

    private static String getStackTraceString(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

