/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.rpc;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.rpc.RpcChannelFactory;
import org.apache.tajo.util.NetUtils;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;

public class NettyServerBase {
    private static final Log LOG = LogFactory.getLog(NettyServerBase.class);
    private static final String DEFAULT_PREFIX = "RpcServer_";
    private static final AtomicInteger sequenceId = new AtomicInteger(0);
    protected String serviceName;
    protected InetSocketAddress serverAddr;
    protected InetSocketAddress bindAddress;
    protected ChannelPipelineFactory pipelineFactory;
    protected ServerBootstrap bootstrap;
    protected Channel channel;
    protected ChannelGroup accepted = new DefaultChannelGroup();
    private InetSocketAddress initIsa;
    private static final int startPortRange = 10000;
    private static final int endPortRange = 50000;
    private static final Random rnd = new Random(System.currentTimeMillis());
    private static final AtomicInteger nextPortNum = new AtomicInteger(10000 + rnd.nextInt(40000));

    public NettyServerBase(InetSocketAddress address) {
        this.initIsa = address;
    }

    public NettyServerBase(String serviceName, InetSocketAddress addr) {
        this.serviceName = serviceName;
        this.initIsa = addr;
    }

    public void setName(String name) {
        this.serviceName = name;
    }

    public void init(ChannelPipelineFactory pipeline, int workerNum) {
        ServerSocketChannelFactory factory = RpcChannelFactory.createServerChannelFactory(this.serviceName, workerNum);
        this.pipelineFactory = pipeline;
        this.bootstrap = new ServerBootstrap((ChannelFactory)factory);
        this.bootstrap.setPipelineFactory(this.pipelineFactory);
        this.bootstrap.setOption("reuseAddress", (Object)true);
        this.bootstrap.setOption("child.tcpNoDelay", (Object)true);
        this.bootstrap.setOption("child.keepAlive", (Object)true);
        this.bootstrap.setOption("child.connectTimeoutMillis", (Object)10000);
        this.bootstrap.setOption("child.connectResponseTimeoutMillis", (Object)10000);
        this.bootstrap.setOption("child.receiveBufferSize", (Object)0xA00000);
    }

    public InetSocketAddress getListenAddress() {
        return this.bindAddress;
    }

    public void start() {
        if (this.serviceName == null) {
            this.serviceName = NettyServerBase.getNextDefaultServiceName();
        }
        if (this.initIsa.getPort() == 0) {
            try {
                int port = NettyServerBase.getUnusedPort();
                this.serverAddr = new InetSocketAddress(this.initIsa.getHostName(), port);
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        } else {
            this.serverAddr = this.initIsa;
        }
        this.channel = this.bootstrap.bind((SocketAddress)this.serverAddr);
        this.bindAddress = (InetSocketAddress)this.channel.getLocalAddress();
        LOG.info((Object)("Rpc (" + this.serviceName + ") listens on " + this.bindAddress));
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void shutdown() {
        if (this.channel != null) {
            this.channel.close().awaitUninterruptibly();
        }
        try {
            this.accepted.close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            LOG.error((Object)t.getMessage(), t);
        }
        if (this.bootstrap != null) {
            this.bootstrap.releaseExternalResources();
        }
        if (this.bindAddress != null) {
            LOG.info((Object)("Rpc (" + this.serviceName + ") listened on " + NetUtils.normalizeInetSocketAddress((InetSocketAddress)this.bindAddress) + ") shutdown"));
        }
    }

    private static String getNextDefaultServiceName() {
        return DEFAULT_PREFIX + sequenceId.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized int getUnusedPort() throws IOException {
        int port;
        do {
            if ((port = nextPortNum.getAndIncrement()) < 50000) continue;
            AtomicInteger atomicInteger = nextPortNum;
            synchronized (atomicInteger) {
                nextPortNum.set(10000);
                port = nextPortNum.getAndIncrement();
            }
        } while (!NettyServerBase.available(port));
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean available(int port) throws IOException {
        if (port < 1024 || port > 65535) {
            throw new IllegalArgumentException("Port Number Out of Bound: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (ss != null) {
                ss.close();
            }
            if (ds != null) {
                ds.close();
            }
        }
    }
}

