/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.rpc;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tajo.rpc.DefaultRpcController;

public class CallFuture<T>
implements RpcCallback<T>,
Future<T> {
    private final Semaphore sem = new Semaphore(0);
    private boolean done = false;
    private T response;
    private RpcController controller = new DefaultRpcController();

    public RpcController getController() {
        return this.controller;
    }

    public void run(T t) {
        this.response = t;
        this.done = true;
        this.sem.release();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCancelled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public T get() throws InterruptedException {
        this.sem.acquire();
        return this.response;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (this.sem.tryAcquire(timeout, unit)) {
            return this.response;
        }
        throw new TimeoutException();
    }
}

