/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.rpc;

import com.google.protobuf.BlockingService;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.RpcController;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.rpc.NettyRpcController;
import org.apache.tajo.rpc.NettyServerBase;
import org.apache.tajo.rpc.ProtoPipelineFactory;
import org.apache.tajo.rpc.RemoteCallException;
import org.apache.tajo.rpc.RpcProtos;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class BlockingRpcServer
extends NettyServerBase {
    private static Log LOG = LogFactory.getLog(BlockingRpcServer.class);
    private final BlockingService service;
    private final ChannelPipelineFactory pipeline;

    public BlockingRpcServer(Class<?> protocol, Object instance, InetSocketAddress bindAddress, int workerNum) throws Exception {
        super(protocol.getSimpleName(), bindAddress);
        String serviceClassName = protocol.getName() + "$" + protocol.getSimpleName() + "Service";
        Class<?> serviceClass = Class.forName(serviceClassName);
        Class<?> interfaceClass = Class.forName(serviceClassName + "$BlockingInterface");
        Method method = serviceClass.getMethod("newReflectiveBlockingService", interfaceClass);
        this.service = (BlockingService)method.invoke(null, instance);
        this.pipeline = new ProtoPipelineFactory((ChannelUpstreamHandler)new ServerHandler(), (MessageLite)RpcProtos.RpcRequest.getDefaultInstance());
        super.init(this.pipeline, workerNum);
    }

    private class ServerHandler
    extends SimpleChannelUpstreamHandler {
        private ServerHandler() {
        }

        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent evt) throws Exception {
            BlockingRpcServer.this.accepted.add((Object)evt.getChannel());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format(BlockingRpcServer.this.serviceName + " accepted number of connections (%d)", BlockingRpcServer.this.accepted.size()));
            }
            super.channelOpen(ctx, evt);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            Message returnValue;
            RpcProtos.RpcRequest request = (RpcProtos.RpcRequest)e.getMessage();
            String methodName = request.getMethodName();
            Descriptors.MethodDescriptor methodDescriptor = BlockingRpcServer.this.service.getDescriptorForType().findMethodByName(methodName);
            if (methodDescriptor == null) {
                throw new RemoteCallException(request.getId(), (Throwable)new NoSuchMethodException(methodName));
            }
            Message paramProto = null;
            if (request.hasRequestMessage()) {
                try {
                    paramProto = BlockingRpcServer.this.service.getRequestPrototype(methodDescriptor).newBuilderForType().mergeFrom(request.getRequestMessage()).build();
                }
                catch (Throwable t) {
                    throw new RemoteCallException(request.getId(), methodDescriptor, t);
                }
            }
            NettyRpcController controller = new NettyRpcController();
            try {
                returnValue = BlockingRpcServer.this.service.callBlockingMethod(methodDescriptor, (RpcController)controller, paramProto);
            }
            catch (Throwable t) {
                throw new RemoteCallException(request.getId(), methodDescriptor, t);
            }
            RpcProtos.RpcResponse.Builder builder = RpcProtos.RpcResponse.newBuilder().setId(request.getId());
            if (returnValue != null) {
                builder.setResponseMessage(returnValue.toByteString());
            }
            if (controller.failed()) {
                builder.setErrorMessage(controller.errorText());
            }
            e.getChannel().write((Object)builder.build());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            if (e.getCause() instanceof RemoteCallException) {
                RemoteCallException callException = (RemoteCallException)e.getCause();
                e.getChannel().write((Object)callException.getResponse());
            }
        }
    }
}

