/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.syncope.common.lib.scim.SCIMConf;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.core.logic.AbstractLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.scim.SCIMConfManager;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.ext.scimv2.api.data.AuthenticationScheme;
import org.apache.syncope.ext.scimv2.api.data.BulkConfigurationOption;
import org.apache.syncope.ext.scimv2.api.data.ConfigurationOption;
import org.apache.syncope.ext.scimv2.api.data.FilterConfigurationOption;
import org.apache.syncope.ext.scimv2.api.data.Meta;
import org.apache.syncope.ext.scimv2.api.data.ResourceType;
import org.apache.syncope.ext.scimv2.api.data.SchemaExtension;
import org.apache.syncope.ext.scimv2.api.data.ServiceProviderConfig;
import org.apache.syncope.ext.scimv2.api.type.Resource;
import org.springframework.security.access.prepost.PreAuthorize;

public class SCIMLogic
extends AbstractLogic<EntityTO> {
    protected static final String SCHEMAS_JSON = "schemas.json";
    protected static final Object MONITOR = new Object();
    protected static ServiceProviderConfig SERVICE_PROVIDER_CONFIG;
    protected static ResourceType USER;
    protected static ResourceType GROUP;
    protected static String SCHEMAS;
    protected static final Map<String, String> SCHEMA_MAP;
    protected final SCIMConfManager confManager;

    public SCIMLogic(SCIMConfManager confManager) {
        this.confManager = confManager;
    }

    protected void init() {
        try {
            JsonMapper mapper = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
            JsonNode tree = mapper.readTree(SCIMLogic.class.getResourceAsStream("/schemas.json"));
            if (!tree.isArray()) {
                throw new IOException("JSON node is not a tree");
            }
            ArrayNode schemaArray = (ArrayNode)tree;
            SCHEMAS = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)tree);
            for (JsonNode schema : schemaArray) {
                SCHEMA_MAP.put(schema.get("id").asText(), mapper.writeValueAsString((Object)schema));
            }
        }
        catch (IOException e) {
            LOG.error("Could not parse the default schema definitions", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="isAuthenticated()")
    public ServiceProviderConfig serviceProviderConfig(UriBuilder uriBuilder) {
        Object object = MONITOR;
        synchronized (object) {
            if (SCHEMAS == null) {
                this.init();
            }
            if (SERVICE_PROVIDER_CONFIG == null) {
                SCIMConf conf = this.confManager.get();
                SERVICE_PROVIDER_CONFIG = new ServiceProviderConfig(new Meta(Resource.ServiceProviderConfig, conf.getGeneralConf().getCreationDate(), conf.getGeneralConf().getLastChangeDate(), conf.getGeneralConf().getETagValue(), uriBuilder.build(new Object[0]).toASCIIString()), new ConfigurationOption(false), new BulkConfigurationOption(false, conf.getGeneralConf().getBulkMaxOperations(), conf.getGeneralConf().getBulkMaxPayloadSize()), new FilterConfigurationOption(true, conf.getGeneralConf().getFilterMaxResults()), new ConfigurationOption(true), new ConfigurationOption(true), new ConfigurationOption(true));
                SERVICE_PROVIDER_CONFIG.getAuthenticationSchemes().add(new AuthenticationScheme("JSON Web Token", "Apache Syncope JWT authentication", URI.create("http://www.rfc-editor.org/info/rfc6750"), URI.create("https://syncope.apache.org/docs/reference-guide.html#rest-authentication-and-authorization"), "oauthbearertoken", true));
                SERVICE_PROVIDER_CONFIG.getAuthenticationSchemes().add(new AuthenticationScheme("HTTP Basic", "Apache Syncope HTTP Basic authentication", URI.create("http://www.rfc-editor.org/info/rfc2617"), URI.create("https://syncope.apache.org/docs/reference-guide.html#rest-authentication-and-authorization"), "httpbasic", false));
            }
        }
        return SERVICE_PROVIDER_CONFIG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="isAuthenticated()")
    public static List<ResourceType> resourceTypes(UriBuilder uriBuilder) {
        Object object = MONITOR;
        synchronized (object) {
            if (USER == null) {
                USER = new ResourceType("User", "User", "/Users", "User Account", Resource.User.schema(), new Meta(Resource.ResourceType, null, null, null, uriBuilder.path("User").build(new Object[0]).toASCIIString()));
                USER.getSchemaExtensions().add(new SchemaExtension(Resource.EnterpriseUser.schema(), true));
            }
            if (GROUP == null) {
                GROUP = new ResourceType("Group", "Group", "/Groups", "Group", Resource.Group.schema(), new Meta(Resource.ResourceType, null, null, null, uriBuilder.path("Group").build(new Object[0]).toASCIIString()));
            }
        }
        return List.of(USER, GROUP);
    }

    @PreAuthorize(value="isAuthenticated()")
    public static ResourceType resourceType(UriBuilder uriBuilder, String type) {
        if (Resource.User.name().equals(type)) {
            SCIMLogic.resourceTypes(uriBuilder);
            return USER;
        }
        if (Resource.Group.name().equals(type)) {
            SCIMLogic.resourceTypes(uriBuilder);
            return GROUP;
        }
        throw new IllegalArgumentException("Unsupported resource type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="isAuthenticated()")
    public String schemas() {
        Object object = MONITOR;
        synchronized (object) {
            if (SCHEMAS == null) {
                this.init();
            }
        }
        return SCHEMAS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="isAuthenticated()")
    public String schema(String schema) {
        Object object = MONITOR;
        synchronized (object) {
            if (SCHEMAS == null) {
                this.init();
            }
        }
        String found = SCHEMA_MAP.get(schema);
        if (found == null) {
            throw new NotFoundException("Schema " + schema + " not found");
        }
        return found;
    }

    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }

    static {
        SCHEMA_MAP = new HashMap<String, String>();
    }
}

