/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.saml2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.to.SAML2IdPTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.SAML2BindingType;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2IdPEntity {
    private static final Logger LOG = LoggerFactory.getLogger(SAML2IdPEntity.class);
    private final String id;
    private SAML2IdPTO idpTO;
    private final Map<String, Endpoint> ssoBindings = new HashMap<String, Endpoint>();
    private final Map<String, SingleLogoutService> sloBindings = new HashMap<String, SingleLogoutService>();
    private final List<String> nameIDFormats = new ArrayList<String>();
    private final KeyStore trustStore;

    public SAML2IdPEntity(EntityDescriptor entityDescriptor, SAML2IdPTO idpTO, String keyPass) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        this.id = entityDescriptor.getEntityID();
        this.idpTO = idpTO;
        IDPSSODescriptor idpdescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        idpdescriptor.getSingleSignOnServices().forEach(sso -> {
            LOG.debug("[{}] Add SSO binding {}({})", new Object[]{this.id, sso.getBinding(), sso.getLocation()});
            this.ssoBindings.put(sso.getBinding(), (Endpoint)sso);
        });
        idpdescriptor.getSingleLogoutServices().forEach(slo -> {
            LOG.debug("[{}] Add SLO binding '{}'\n\tLocation: '{}'\n\tResponse Location: '{}'", new Object[]{this.id, slo.getBinding(), slo.getLocation(), slo.getResponseLocation()});
            this.sloBindings.put(slo.getBinding(), (SingleLogoutService)slo);
        });
        idpdescriptor.getNameIDFormats().forEach(nameIDFormat -> {
            LOG.debug("[{}] Add NameIDFormat '{}'", (Object)this.id, (Object)nameIDFormat.getFormat());
            this.nameIDFormats.add(nameIDFormat.getFormat());
        });
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ArrayList chain = new ArrayList();
        for (KeyDescriptor key : idpdescriptor.getKeyDescriptors()) {
            for (X509Data x509Data : key.getKeyInfo().getX509Datas()) {
                for (X509Certificate cert : x509Data.getX509Certificates()) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getMimeDecoder().decode(cert.getValue()));
                    Throwable throwable = null;
                    try {
                        chain.add(java.security.cert.X509Certificate.class.cast(cf.generateCertificate(bais)));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (bais == null) continue;
                        if (throwable != null) {
                            try {
                                bais.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        bais.close();
                    }
                }
            }
        }
        this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.trustStore.load(null, keyPass.toCharArray());
        if (!chain.isEmpty()) {
            for (java.security.cert.X509Certificate cert : chain) {
                LOG.debug("[{}] Add X.509 certificate {}", (Object)this.id, (Object)cert.getSubjectX500Principal().getName());
                this.trustStore.setCertificateEntry(cert.getSubjectX500Principal().getName(), cert);
            }
            LOG.debug("[{}] Set default X.509 certificate {}", (Object)this.id, (Object)((java.security.cert.X509Certificate)chain.get(0)).getSubjectX500Principal().getName());
            this.trustStore.setCertificateEntry(this.id, (Certificate)chain.get(0));
        }
    }

    public void setIdpTO(SAML2IdPTO idpTO) {
        this.idpTO = idpTO;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.idpTO.getKey();
    }

    public boolean isCreateUnmatching() {
        return this.idpTO.isCreateUnmatching();
    }

    public boolean isSelfRegUnmatching() {
        return this.idpTO.isSelfRegUnmatching();
    }

    public boolean isUpdateMatching() {
        return this.idpTO.isUpdateMatching();
    }

    public boolean isUseDeflateEncoding() {
        return this.idpTO.isUseDeflateEncoding();
    }

    public boolean isSupportUnsolicited() {
        return this.idpTO.isSupportUnsolicited();
    }

    public SAML2BindingType getBindingType() {
        return this.idpTO.getBindingType();
    }

    public ItemTO getConnObjectKeyItem() {
        return this.idpTO.getConnObjectKeyItem();
    }

    public UserTO getUserTemplate() {
        return this.idpTO.getUserTemplate();
    }

    public List<String> getActionsClassNames() {
        return this.idpTO.getActionsClassNames();
    }

    public String getRequestedAuthnContextProviderClassName() {
        return this.idpTO.getRequestedAuthnContextProviderClassName();
    }

    public Endpoint getSSOLocation(SAML2BindingType bindingType) {
        return this.ssoBindings.get(bindingType.getUri());
    }

    public Endpoint getSLOLocation(SAML2BindingType bindingType) {
        return (Endpoint)this.sloBindings.get(bindingType.getUri());
    }

    public boolean supportsNameIDFormat(String nameIDFormat) {
        return this.nameIDFormats.contains(nameIDFormat);
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }
}

