/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.syncope.core.persistence.api.ImplementationLookup;
import org.apache.syncope.core.persistence.api.SyncopeLoader;
import org.apache.syncope.core.provisioning.api.SAML2IdPActions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class SAML2SPClassPathScanImplementationLookup
implements SyncopeLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ImplementationLookup.class);
    private static final String DEFAULT_BASE_PACKAGE = "org.apache.syncope.core";
    private Set<String> actionsClasses;

    public Integer getPriority() {
        return Integer.MIN_VALUE;
    }

    public void load() {
        this.actionsClasses = new HashSet<String>();
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(SAML2IdPActions.class));
        for (BeanDefinition bd : scanner.findCandidateComponents(DEFAULT_BASE_PACKAGE)) {
            try {
                Class clazz = ClassUtils.resolveClassName((String)bd.getBeanClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                boolean isAbstractClazz = Modifier.isAbstract(clazz.getModifiers());
                if (!SAML2IdPActions.class.isAssignableFrom(clazz) || isAbstractClazz) continue;
                this.actionsClasses.add(clazz.getName());
            }
            catch (Throwable t) {
                LOG.warn("Could not inspect class {}", (Object)bd.getBeanClassName(), (Object)t);
            }
        }
        this.actionsClasses = Collections.unmodifiableSet(this.actionsClasses);
    }

    public Set<String> getActionsClasses() {
        return this.actionsClasses;
    }
}

