/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.saml2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.zip.DataFormatException;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.cxf.rs.security.saml.sso.SAMLProtocolResponseValidator;
import org.apache.cxf.rs.security.saml.sso.SAMLSSOResponseValidator;
import org.apache.cxf.rs.security.saml.sso.SSOValidatorResponse;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.syncope.common.lib.types.SAML2BindingType;
import org.apache.syncope.common.lib.types.SignatureAlgorithm;
import org.apache.syncope.core.logic.init.SAML2SPLoader;
import org.apache.syncope.core.logic.saml2.SAML2IdPEntity;
import org.apache.syncope.core.logic.saml2.SAMLSPCallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.xml.security.algorithms.JCEMapper;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.security.SecurityException;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class SAML2ReaderWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SAML2ReaderWriter.class);
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    @Autowired
    private SAML2SPLoader loader;
    private KeyInfoGenerator keyInfoGenerator;
    private String sigAlgo;
    private String jceSigAlgo;
    private SAMLSPCallbackHandler callbackHandler;

    public void init() {
        X509KeyInfoGeneratorFactory keyInfoGeneratorFactory = new X509KeyInfoGeneratorFactory();
        keyInfoGeneratorFactory.setEmitEntityCertificate(true);
        this.keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
        if (this.loader.getSignatureAlgorithm() != null) {
            SignatureAlgorithm loadedSignatureAlgorithm = SignatureAlgorithm.valueOf((String)this.loader.getSignatureAlgorithm());
            if (loadedSignatureAlgorithm != null) {
                this.sigAlgo = loadedSignatureAlgorithm.getAlgorithm();
                this.jceSigAlgo = JCEMapper.translateURItoJCEID((String)this.sigAlgo);
            }
            if (this.jceSigAlgo == null) {
                LOG.warn("Signature algorithm {} is not valid. Using default algorithm instead.", (Object)this.loader.getSignatureAlgorithm());
                this.sigAlgo = null;
            }
        }
        if (this.sigAlgo == null) {
            this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            String pubKeyAlgo = this.loader.getCredential().getPublicKey().getAlgorithm();
            if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            } else if (pubKeyAlgo.equalsIgnoreCase("EC")) {
                this.sigAlgo = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
            }
            this.jceSigAlgo = JCEMapper.translateURItoJCEID((String)this.sigAlgo);
        }
        this.callbackHandler = new SAMLSPCallbackHandler(this.loader.getKeyPass());
    }

    public String getSigAlgo() {
        return this.sigAlgo;
    }

    public void write(Writer writer, XMLObject object, boolean signObject) throws TransformerConfigurationException, WSSecurityException, TransformerException {
        Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
        StreamResult streamResult = new StreamResult(writer);
        DOMSource source = new DOMSource(OpenSAMLUtil.toDom((XMLObject)object, null, (boolean)signObject));
        transformer.transform(source, streamResult);
    }

    public XMLObject read(boolean useDeflateEncoding, String response) throws DataFormatException, UnsupportedEncodingException, XMLStreamException, WSSecurityException {
        byte[] deflatedToken = Base64.decodeBase64((String)response);
        InputStream tokenStream = useDeflateEncoding ? new DeflateEncoderDecoder().inflateToken(deflatedToken) : new ByteArrayInputStream(deflatedToken);
        Document responseDoc = StaxUtils.read((Reader)new InputStreamReader(tokenStream, StandardCharsets.UTF_8));
        XMLObject responseObject = OpenSAMLUtil.fromDom((Element)responseDoc.getDocumentElement());
        if (LOG.isDebugEnabled()) {
            try {
                StringWriter writer = new StringWriter();
                this.write(writer, responseObject, false);
                writer.close();
                LOG.debug("Parsed SAML response: {}", (Object)writer.toString());
            }
            catch (Exception e) {
                LOG.error("Could not log the received SAML response", (Throwable)e);
            }
        }
        return responseObject;
    }

    public void sign(SignableSAMLObject signableObject) throws SecurityException {
        Signature signature = OpenSAMLUtil.buildSignature();
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signature.setSignatureAlgorithm(this.sigAlgo);
        signature.setSigningCredential(this.loader.getCredential());
        signature.setKeyInfo(this.keyInfoGenerator.generate(this.loader.getCredential()));
        signableObject.setSignature(signature);
        signableObject.releaseDOM();
        signableObject.releaseChildrenDOM(true);
    }

    public String sign(String request, String relayState) throws NoSuchAlgorithmException, WSSecurityException, InvalidKeyException, UnsupportedEncodingException, SignatureException {
        Merlin crypto = new Merlin();
        crypto.setKeyStore(this.loader.getKeyStore());
        PrivateKey privateKey = crypto.getPrivateKey(this.loader.getCredential().getPublicKey(), (CallbackHandler)this.callbackHandler);
        java.security.Signature signature = java.security.Signature.getInstance(this.jceSigAlgo);
        signature.initSign(privateKey);
        String requestToSign = "SAMLRequest=" + request + "&" + "RelayState" + "=" + relayState + "&" + "SigAlg" + "=" + URLEncoder.encode(this.sigAlgo, StandardCharsets.UTF_8.name());
        signature.update(requestToSign.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBase64String((byte[])signature.sign());
    }

    public String encode(RequestAbstractType request, boolean useDeflateEncoding) throws WSSecurityException, TransformerException, IOException {
        StringWriter writer = new StringWriter();
        this.write(writer, (XMLObject)request, true);
        writer.close();
        String requestMessage = writer.toString();
        byte[] deflatedBytes = useDeflateEncoding ? new DeflateEncoderDecoder().deflateToken(requestMessage.getBytes(StandardCharsets.UTF_8)) : requestMessage.getBytes(StandardCharsets.UTF_8);
        return Base64.encodeBase64String((byte[])deflatedBytes);
    }

    public SSOValidatorResponse validate(Response samlResponse, SAML2IdPEntity idp, String assertionConsumerURL, String requestId, String spEntityID) throws WSSecurityException {
        Merlin crypto = new Merlin();
        crypto.setKeyStore(this.loader.getKeyStore());
        crypto.setTrustStore(idp.getTrustStore());
        SAMLProtocolResponseValidator protocolValidator = new SAMLProtocolResponseValidator();
        protocolValidator.setKeyInfoMustBeAvailable(true);
        protocolValidator.validateSamlResponse(samlResponse, (Crypto)crypto, (CallbackHandler)this.callbackHandler);
        SAMLSSOResponseValidator ssoResponseValidator = new SAMLSSOResponseValidator();
        ssoResponseValidator.setAssertionConsumerURL(assertionConsumerURL);
        ssoResponseValidator.setIssuerIDP(idp.getId());
        ssoResponseValidator.setRequestId(requestId);
        ssoResponseValidator.setSpIdentifier(spEntityID);
        SSOValidatorResponse validatorResponse = ssoResponseValidator.validateSamlResponse(samlResponse, idp.getBindingType() == SAML2BindingType.POST);
        if (LOG.isDebugEnabled()) {
            try {
                StringWriter writer = new StringWriter();
                this.write(writer, (XMLObject)samlResponse, false);
                writer.close();
                LOG.debug("SAML response with decrypted assertions: {}", (Object)writer.toString());
            }
            catch (Exception e) {
                LOG.error("Could not log the SAML response with decrypted assertions", (Throwable)e);
            }
        }
        return validatorResponse;
    }

    static {
        try {
            TRANSFORMER_FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            LOG.error("Could not enable secure XML processing", (Throwable)e);
        }
    }
}

