/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.saml2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.syncope.common.lib.to.MappingItemTO;
import org.apache.syncope.common.lib.types.SAML2BindingType;
import org.apache.syncope.core.logic.init.SAML2SPLoader;
import org.apache.syncope.core.logic.saml2.SAML2IdPEntity;
import org.apache.syncope.core.persistence.api.entity.SAML2IdP;
import org.apache.syncope.core.provisioning.api.data.SAML2IdPDataBinder;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Element;

@Component
public class SAML2IdPCache {
    private final Map<String, SAML2IdPEntity> cache = Collections.synchronizedMap(new HashMap());
    @Autowired
    private SAML2SPLoader loader;
    @Autowired
    private SAML2IdPDataBinder binder;

    public SAML2IdPEntity get(String entityID) {
        return this.cache.get(entityID);
    }

    public SAML2IdPEntity getFirst() {
        return this.cache.isEmpty() ? null : this.cache.entrySet().iterator().next().getValue();
    }

    public SAML2IdPEntity put(EntityDescriptor entityDescriptor, MappingItemTO connObjectKeyItem, boolean useDeflateEncoding, SAML2BindingType bindingType) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        SAML2IdPEntity idp = new SAML2IdPEntity(entityDescriptor, connObjectKeyItem, useDeflateEncoding, bindingType, this.loader.getKeyPass());
        this.cache.put(entityDescriptor.getEntityID(), idp);
        return idp;
    }

    @Transactional(readOnly=true)
    public SAML2IdPEntity put(SAML2IdP idp) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, WSSecurityException, XMLParserException {
        Element element = OpenSAMLUtil.getParserPool().parse((Reader)new InputStreamReader(new ByteArrayInputStream(idp.getMetadata()))).getDocumentElement();
        EntityDescriptor entityDescriptor = (EntityDescriptor)OpenSAMLUtil.fromDom((Element)element);
        return this.put(entityDescriptor, this.binder.getIdPTO(idp).getConnObjectKeyItem(), idp.isUseDeflateEncoding(), idp.getBindingType());
    }

    public SAML2IdPEntity remove(String entityID) {
        return this.cache.remove(entityID);
    }
}

