/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.RandomBasedGenerator;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MappingItemTO;
import org.apache.syncope.common.lib.to.SAML2LoginResponseTO;
import org.apache.syncope.common.lib.to.SAML2ReceivedResponseTO;
import org.apache.syncope.common.lib.to.SAML2RequestTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.SAML2BindingType;
import org.apache.syncope.core.logic.AbstractSAML2Logic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.saml2.SAML2IdPCache;
import org.apache.syncope.core.logic.saml2.SAML2IdPEntity;
import org.apache.syncope.core.logic.saml2.SAML2ReaderWriter;
import org.apache.syncope.core.persistence.api.attrvalue.validation.ParsingValidationException;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2IdPDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.SAML2IdP;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.data.AccessTokenDataBinder;
import org.apache.syncope.core.provisioning.api.utils.EntityUtils;
import org.apache.syncope.core.provisioning.java.IntAttrNameParser;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.saml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.impl.AssertionConsumerServiceBuilder;
import org.opensaml.saml.saml2.metadata.impl.EntityDescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.KeyDescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.NameIDFormatBuilder;
import org.opensaml.saml.saml2.metadata.impl.SPSSODescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.SingleLogoutServiceBuilder;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Component;

@Component
public class SAML2SPLogic
extends AbstractSAML2Logic<AbstractBaseBean> {
    private static final Integer JWT_RELAY_STATE_DURATION = 5;
    private static final String JWT_CLAIM_IDP_DEFLATE = "IDP_DEFLATE";
    private static final String JWT_CLAIM_IDP_ENTITYID = "IDP_ENTITYID";
    private static final String JWT_CLAIM_NAMEID_FORMAT = "NAMEID_FORMAT";
    private static final String JWT_CLAIM_NAMEID_VALUE = "NAMEID_VALUE";
    private static final String JWT_CLAIM_SESSIONINDEX = "SESSIONINDEX";
    private static final RandomBasedGenerator UUID_GENERATOR = Generators.randomBasedGenerator();
    @Autowired
    private JwsSignatureVerifier jwsSignatureCerifier;
    @Autowired
    private AccessTokenDataBinder accessTokenDataBinder;
    @Autowired
    private SAML2IdPCache cache;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private SAML2IdPDAO saml2IdPDAO;
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private AccessTokenDAO accessTokenDAO;
    @Autowired
    private IntAttrNameParser intAttrNameParser;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private SAML2ReaderWriter saml2rw;

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void getMetadata(String spEntityID, String urlContext, OutputStream os) {
        this.check();
        try {
            EntityDescriptor spEntityDescriptor = new EntityDescriptorBuilder().buildObject();
            spEntityDescriptor.setEntityID(spEntityID);
            SPSSODescriptor spSSODescriptor = new SPSSODescriptorBuilder().buildObject();
            spSSODescriptor.setWantAssertionsSigned(Boolean.valueOf(true));
            spSSODescriptor.setAuthnRequestsSigned(Boolean.valueOf(true));
            spSSODescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
            X509KeyInfoGeneratorFactory keyInfoGeneratorFactory = new X509KeyInfoGeneratorFactory();
            keyInfoGeneratorFactory.setEmitEntityCertificate(true);
            KeyInfoGenerator keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
            keyInfoGenerator.generate(this.loader.getCredential());
            KeyDescriptor keyDescriptor = new KeyDescriptorBuilder().buildObject();
            keyDescriptor.setKeyInfo(keyInfoGenerator.generate(this.loader.getCredential()));
            spSSODescriptor.getKeyDescriptors().add(keyDescriptor);
            NameIDFormat nameIDFormat = new NameIDFormatBuilder().buildObject();
            nameIDFormat.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
            spSSODescriptor.getNameIDFormats().add(nameIDFormat);
            nameIDFormat = new NameIDFormatBuilder().buildObject();
            nameIDFormat.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
            spSSODescriptor.getNameIDFormats().add(nameIDFormat);
            for (SAML2BindingType bindingType : SAML2BindingType.values()) {
                AssertionConsumerService assertionConsumerService = new AssertionConsumerServiceBuilder().buildObject();
                assertionConsumerService.setIndex(Integer.valueOf(bindingType.ordinal()));
                assertionConsumerService.setBinding(bindingType.getUri());
                assertionConsumerService.setLocation(spEntityID + urlContext + "/assertion-consumer");
                spSSODescriptor.getAssertionConsumerServices().add(assertionConsumerService);
                spEntityDescriptor.getRoleDescriptors().add(spSSODescriptor);
                SingleLogoutService singleLogoutService = new SingleLogoutServiceBuilder().buildObject();
                singleLogoutService.setBinding(bindingType.getUri());
                singleLogoutService.setLocation(spEntityID + urlContext + "/logout");
                singleLogoutService.setResponseLocation(spEntityID + urlContext + "/logout");
                spSSODescriptor.getSingleLogoutServices().add(singleLogoutService);
            }
            spEntityDescriptor.getRoleDescriptors().add(spSSODescriptor);
            this.saml2rw.write(new OutputStreamWriter(os), (XMLObject)spEntityDescriptor, true);
        }
        catch (Exception e) {
            LOG.error("While getting SP metadata", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    private SAML2IdPEntity getIdP(String entityID) {
        SAML2IdPEntity idp = null;
        SAML2IdP saml2IdP = this.saml2IdPDAO.findByEntityID(entityID);
        if (saml2IdP != null) {
            try {
                idp = this.cache.put(saml2IdP);
            }
            catch (Exception e) {
                LOG.error("Could not build SAML 2.0 IdP with key ", (Object)entityID, (Object)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
                sce.getElements().add(e.getMessage());
                throw sce;
            }
        }
        if (idp == null) {
            throw new NotFoundException("SAML 2.0 IdP '" + entityID + "'");
        }
        return idp;
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public SAML2RequestTO createLoginRequest(String spEntityID, String idpEntityID) {
        SAML2IdPEntity idp;
        this.check();
        SAML2IdPEntity sAML2IdPEntity = idp = StringUtils.isBlank((CharSequence)idpEntityID) ? this.cache.getFirst() : this.cache.get(idpEntityID);
        if (idp == null) {
            if (StringUtils.isBlank((CharSequence)idpEntityID)) {
                List all = this.saml2IdPDAO.findAll();
                if (!all.isEmpty()) {
                    idp = this.getIdP(((SAML2IdP)all.get(0)).getKey());
                }
            } else {
                idp = this.getIdP(idpEntityID);
            }
        }
        if (idp == null) {
            throw new NotFoundException(StringUtils.isBlank((CharSequence)idpEntityID) ? "Any SAML 2.0 IdP" : "SAML 2.0 IdP '" + idpEntityID + "'");
        }
        if (idp.getSSOLocation(idp.getBindingType()) == null) {
            throw new IllegalArgumentException("No SingleSignOnService available for " + idp.getId());
        }
        Issuer issuer = new IssuerBuilder().buildObject();
        issuer.setValue(spEntityID);
        NameIDPolicy nameIDPolicy = new NameIDPolicyBuilder().buildObject();
        if (idp.supportsNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient")) {
            nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        } else if (idp.supportsNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent")) {
            nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        } else {
            throw new IllegalArgumentException("Could not find supported NameIDFormat for IdP " + idpEntityID);
        }
        nameIDPolicy.setAllowCreate(Boolean.valueOf(true));
        nameIDPolicy.setSPNameQualifier(spEntityID);
        AuthnContextClassRef authnContextClassRef = new AuthnContextClassRefBuilder().buildObject();
        authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        RequestedAuthnContext requestedAuthnContext = new RequestedAuthnContextBuilder().buildObject();
        requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
        requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassRef);
        AuthnRequest authnRequest = new AuthnRequestBuilder().buildObject();
        authnRequest.setID("_" + UUID_GENERATOR.generate().toString());
        authnRequest.setForceAuthn(Boolean.valueOf(false));
        authnRequest.setIsPassive(Boolean.valueOf(false));
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setProtocolBinding(idp.getBindingType().getUri());
        authnRequest.setIssueInstant(new DateTime());
        authnRequest.setIssuer(issuer);
        authnRequest.setNameIDPolicy(nameIDPolicy);
        authnRequest.setRequestedAuthnContext(requestedAuthnContext);
        authnRequest.setDestination(idp.getSSOLocation(idp.getBindingType()).getLocation());
        SAML2RequestTO requestTO = new SAML2RequestTO();
        requestTO.setIdpServiceAddress(authnRequest.getDestination());
        requestTO.setBindingType(idp.getBindingType());
        try {
            HashMap<String, Boolean> claims = new HashMap<String, Boolean>();
            claims.put(JWT_CLAIM_IDP_DEFLATE, idp.isUseDeflateEncoding());
            Triple relayState = this.accessTokenDataBinder.generateJWT(authnRequest.getID(), JWT_RELAY_STATE_DURATION.intValue(), claims);
            switch (idp.getBindingType()) {
                case REDIRECT: {
                    requestTO.setRelayState(URLEncoder.encode((String)relayState.getMiddle(), StandardCharsets.UTF_8.name()));
                    requestTO.setContent(URLEncoder.encode(this.saml2rw.encode((RequestAbstractType)authnRequest, true), StandardCharsets.UTF_8.name()));
                    requestTO.setSignAlg(URLEncoder.encode(this.saml2rw.getSigAlgo(), StandardCharsets.UTF_8.name()));
                    requestTO.setSignature(URLEncoder.encode(this.saml2rw.sign(requestTO.getContent(), requestTO.getRelayState()), StandardCharsets.UTF_8.name()));
                    break;
                }
                default: {
                    requestTO.setRelayState((String)relayState.getMiddle());
                    this.saml2rw.sign((RequestAbstractType)authnRequest);
                    requestTO.setContent(this.saml2rw.encode((RequestAbstractType)authnRequest, idp.isUseDeflateEncoding()));
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error("While generating AuthnRequest", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return requestTO;
    }

    private List<String> findMatchingUser(String keyValue, MappingItemTO connObjectKeyItem) {
        ArrayList<String> result = new ArrayList<String>();
        String transformed = keyValue;
        for (Object transformer : MappingUtils.getMappingItemTransformers((MappingItemTO)connObjectKeyItem)) {
            List output = transformer.beforePull(null, null, Collections.singletonList(transformed));
            if (output == null || output.isEmpty()) continue;
            transformed = output.get(0).toString();
        }
        IntAttrName intAttrName = this.intAttrNameParser.parse(connObjectKeyItem.getIntAttrName(), AnyTypeKind.USER);
        if (intAttrName.getField() != null) {
            switch (intAttrName.getField()) {
                case "key": {
                    User byKey = (User)this.userDAO.find(transformed);
                    if (byKey == null) break;
                    result.add(byKey.getKey());
                    break;
                }
                case "username": {
                    User byUsername = this.userDAO.findByUsername(transformed);
                    if (byUsername == null) break;
                    result.add(byUsername.getKey());
                    break;
                }
            }
        } else if (intAttrName.getSchemaType() != null) {
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    PlainAttrValue value = (PlainAttrValue)this.entityFactory.newEntity(UPlainAttrValue.class);
                    PlainSchema schema = (PlainSchema)this.plainSchemaDAO.find(intAttrName.getSchemaName());
                    if (schema == null) {
                        value.setStringValue(transformed);
                    } else {
                        try {
                            value.parseValue(schema, transformed);
                        }
                        catch (ParsingValidationException e) {
                            LOG.error("While parsing provided key value {}", (Object)transformed, (Object)e);
                            value.setStringValue(transformed);
                        }
                    }
                    CollectionUtils.collect((Iterable)this.userDAO.findByAttrValue(intAttrName.getSchemaName(), value), (Transformer)EntityUtils.keyTransformer(), result);
                    break;
                }
                case DERIVED: {
                    CollectionUtils.collect((Iterable)this.userDAO.findByDerAttrValue(intAttrName.getSchemaName(), transformed), (Transformer)EntityUtils.keyTransformer(), result);
                    break;
                }
            }
        }
        return result;
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public SAML2LoginResponseTO validateLoginResponse(SAML2ReceivedResponseTO response) {
        Response samlResponse;
        this.check();
        JwsJwtCompactConsumer relayState = new JwsJwtCompactConsumer(response.getRelayState());
        if (!relayState.verifySignatureWith(this.jwsSignatureCerifier)) {
            throw new IllegalArgumentException("Invalid signature found in Relay State");
        }
        Boolean useDeflateEncoding = Boolean.valueOf(relayState.getJwtClaims().getClaim(JWT_CLAIM_IDP_DEFLATE).toString());
        try {
            XMLObject responseObject = this.saml2rw.read(useDeflateEncoding, response.getSamlResponse());
            if (!(responseObject instanceof Response)) {
                throw new IllegalArgumentException("Expected " + Response.class.getName() + ", got " + responseObject.getClass().getName());
            }
            samlResponse = (Response)responseObject;
        }
        catch (Exception e) {
            LOG.error("While parsing AuthnResponse", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        if (!relayState.getJwtClaims().getSubject().equals(samlResponse.getInResponseTo())) {
            throw new IllegalArgumentException("Unmatching request ID: " + samlResponse.getInResponseTo());
        }
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(samlResponse.getStatus().getStatusCode().getValue())) {
            throw new BadCredentialsException("The SAML IdP replied with " + samlResponse.getStatus().getStatusCode().getValue());
        }
        SAML2IdPEntity idp = this.getIdP(samlResponse.getIssuer().getValue());
        if (idp.getConnObjectKeyItem() == null) {
            throw new IllegalArgumentException("No mapping provided for SAML 2.0 IdP '" + idp.getId() + "'");
        }
        try {
            this.saml2rw.validate(samlResponse, idp.getTrustStore());
        }
        catch (Exception e) {
            LOG.error("While validating AuthnResponse", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        SAML2LoginResponseTO responseTO = new SAML2LoginResponseTO();
        responseTO.setIdp(idp.getId());
        responseTO.setSloSupported(idp.getSLOLocation(idp.getBindingType()) != null);
        NameID nameID = null;
        String keyValue = null;
        for (Assertion assertion : samlResponse.getAssertions()) {
            nameID = assertion.getSubject().getNameID();
            if (StringUtils.isNotBlank((CharSequence)nameID.getValue()) && idp.getConnObjectKeyItem().getExtAttrName().equals("NameID")) {
                keyValue = nameID.getValue();
            }
            if (assertion.getConditions().getNotOnOrAfter() != null) {
                responseTO.setNotOnOrAfter(assertion.getConditions().getNotOnOrAfter().toDate());
            }
            for (AuthnStatement authnStmt : assertion.getAuthnStatements()) {
                responseTO.setSessionIndex(authnStmt.getSessionIndex());
                responseTO.setAuthInstant(authnStmt.getAuthnInstant().toDate());
                if (authnStmt.getSessionNotOnOrAfter() == null) continue;
                responseTO.setNotOnOrAfter(authnStmt.getSessionNotOnOrAfter().toDate());
            }
            for (AttributeStatement attrStmt : assertion.getAttributeStatements()) {
                for (Attribute attr : attrStmt.getAttributes()) {
                    String attrName;
                    if (attr.getAttributeValues().isEmpty()) continue;
                    String string = attrName = attr.getFriendlyName() == null ? attr.getName() : attr.getFriendlyName();
                    if (attrName.equals(idp.getConnObjectKeyItem().getExtAttrName()) && attr.getAttributeValues().get(0) instanceof XSString) {
                        keyValue = ((XSString)attr.getAttributeValues().get(0)).getValue();
                    }
                    AttrTO attrTO = new AttrTO();
                    attrTO.setSchema(attrName);
                    for (XMLObject value : attr.getAttributeValues()) {
                        if (value.getDOM() == null) continue;
                        attrTO.getValues().add(value.getDOM().getTextContent());
                    }
                    responseTO.getAttrs().add(attrTO);
                }
            }
        }
        if (nameID == null) {
            throw new IllegalArgumentException("NameID not found");
        }
        List matchingUsers = keyValue == null ? Collections.emptyList() : this.findMatchingUser(keyValue, idp.getConnObjectKeyItem());
        LOG.debug("Found {} matching users for NameID {}", (Object)matchingUsers.size(), (Object)nameID.getValue());
        if (matchingUsers.isEmpty()) {
            throw new NotFoundException("User matching the provided NameID value " + nameID.getValue());
        }
        if (matchingUsers.size() > 1) {
            throw new IllegalArgumentException("Several users match the provided NameID value " + nameID.getValue());
        }
        responseTO.setUsername(((User)this.userDAO.find((String)matchingUsers.get(0))).getUsername());
        responseTO.setNameID(nameID.getValue());
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put(JWT_CLAIM_IDP_ENTITYID, idp.getId());
        claims.put(JWT_CLAIM_NAMEID_FORMAT, nameID.getFormat());
        claims.put(JWT_CLAIM_NAMEID_VALUE, nameID.getValue());
        claims.put(JWT_CLAIM_SESSIONINDEX, responseTO.getSessionIndex());
        responseTO.setAccessToken(this.accessTokenDataBinder.create(responseTO.getUsername(), claims, true));
        return responseTO;
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    public SAML2RequestTO createLogoutRequest(String accessToken, String spEntityID) {
        this.check();
        JwsJwtCompactConsumer consumer = new JwsJwtCompactConsumer(accessToken);
        if (!consumer.verifySignatureWith(this.jwsSignatureCerifier)) {
            throw new IllegalArgumentException("Invalid signature found in Access Token");
        }
        String idpEntityID = (String)consumer.getJwtClaims().getClaim(JWT_CLAIM_IDP_ENTITYID);
        if (idpEntityID == null) {
            throw new NotFoundException("No SAML 2.0 IdP information found in the access token");
        }
        SAML2IdPEntity idp = this.cache.get(idpEntityID);
        if (idp == null) {
            throw new NotFoundException("SAML 2.0 IdP '" + idpEntityID + "'");
        }
        if (idp.getSLOLocation(idp.getBindingType()) == null) {
            throw new IllegalArgumentException("No SingleLogoutService available for " + idp.getId());
        }
        LogoutRequest logoutRequest = new LogoutRequestBuilder().buildObject();
        logoutRequest.setID("_" + UUID_GENERATOR.generate().toString());
        logoutRequest.setDestination(idp.getSLOLocation(idp.getBindingType()).getLocation());
        DateTime now = new DateTime();
        logoutRequest.setIssueInstant(now);
        logoutRequest.setNotOnOrAfter(now.plusMinutes(5));
        Issuer issuer = new IssuerBuilder().buildObject();
        issuer.setValue(spEntityID);
        logoutRequest.setIssuer(issuer);
        NameID nameID = new NameIDBuilder().buildObject();
        nameID.setFormat((String)consumer.getJwtClaims().getClaim(JWT_CLAIM_NAMEID_FORMAT));
        nameID.setValue((String)consumer.getJwtClaims().getClaim(JWT_CLAIM_NAMEID_VALUE));
        logoutRequest.setNameID(nameID);
        SessionIndex sessionIndex = new SessionIndexBuilder().buildObject();
        sessionIndex.setSessionIndex((String)consumer.getJwtClaims().getClaim(JWT_CLAIM_SESSIONINDEX));
        logoutRequest.getSessionIndexes().add(sessionIndex);
        SAML2RequestTO requestTO = new SAML2RequestTO();
        requestTO.setIdpServiceAddress(logoutRequest.getDestination());
        requestTO.setBindingType(idp.getBindingType());
        try {
            HashMap<String, Boolean> claims = new HashMap<String, Boolean>();
            claims.put(JWT_CLAIM_IDP_DEFLATE, idp.getBindingType() == SAML2BindingType.REDIRECT ? true : idp.isUseDeflateEncoding());
            Triple relayState = this.accessTokenDataBinder.generateJWT(logoutRequest.getID(), JWT_RELAY_STATE_DURATION.intValue(), claims);
            requestTO.setRelayState((String)relayState.getMiddle());
            switch (idp.getBindingType()) {
                case REDIRECT: {
                    requestTO.setContent(this.saml2rw.encode((RequestAbstractType)logoutRequest, true));
                    requestTO.setSignAlg(this.saml2rw.getSigAlgo());
                    requestTO.setSignature(this.saml2rw.sign(requestTO.getContent(), requestTO.getRelayState()));
                    break;
                }
                default: {
                    this.saml2rw.sign((RequestAbstractType)logoutRequest);
                    requestTO.setContent(this.saml2rw.encode((RequestAbstractType)logoutRequest, idp.isUseDeflateEncoding()));
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error("While generating LogoutRequest", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return requestTO;
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    public void validateLogoutResponse(String accessToken, SAML2ReceivedResponseTO response) {
        LogoutResponse logoutResponse;
        this.check();
        JwsJwtCompactConsumer consumer = new JwsJwtCompactConsumer(accessToken);
        if (!consumer.verifySignatureWith(this.jwsSignatureCerifier)) {
            throw new IllegalArgumentException("Invalid signature found in Access Token");
        }
        JwsJwtCompactConsumer relayState = null;
        Boolean useDeflateEncoding = false;
        if (StringUtils.isNotBlank((CharSequence)response.getRelayState())) {
            relayState = new JwsJwtCompactConsumer(response.getRelayState());
            if (!relayState.verifySignatureWith(this.jwsSignatureCerifier)) {
                throw new IllegalArgumentException("Invalid signature found in Relay State");
            }
            useDeflateEncoding = Boolean.valueOf(relayState.getJwtClaims().getClaim(JWT_CLAIM_IDP_DEFLATE).toString());
        }
        try {
            XMLObject responseObject = this.saml2rw.read(useDeflateEncoding, response.getSamlResponse());
            if (!(responseObject instanceof LogoutResponse)) {
                throw new IllegalArgumentException("Expected " + LogoutResponse.class.getName() + ", got " + responseObject.getClass().getName());
            }
            logoutResponse = (LogoutResponse)responseObject;
        }
        catch (Exception e) {
            LOG.error("While parsing LogoutResponse", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        if (relayState != null && !relayState.getJwtClaims().getSubject().equals(logoutResponse.getInResponseTo())) {
            throw new IllegalArgumentException("Unmatching request ID: " + logoutResponse.getInResponseTo());
        }
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(logoutResponse.getStatus().getStatusCode().getValue())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            if (logoutResponse.getStatus().getStatusMessage() == null) {
                sce.getElements().add(logoutResponse.getStatus().getStatusCode().getValue());
            } else {
                sce.getElements().add(logoutResponse.getStatus().getStatusMessage().getMessage());
            }
            throw sce;
        }
        this.accessTokenDAO.delete(consumer.getJwtClaims().getTokenId());
    }

    protected AbstractBaseBean resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

