/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.to.SAML2IdPTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.SAML2BindingType;
import org.apache.syncope.core.logic.AbstractSAML2Logic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.init.SAML2SPClassPathScanImplementationLookup;
import org.apache.syncope.core.logic.saml2.SAML2IdPCache;
import org.apache.syncope.core.logic.saml2.SAML2IdPEntity;
import org.apache.syncope.core.logic.saml2.SAML2ReaderWriter;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.SAML2IdPDAO;
import org.apache.syncope.core.persistence.api.entity.SAML2IdP;
import org.apache.syncope.core.provisioning.api.data.SAML2IdPDataBinder;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class SAML2IdPLogic
extends AbstractSAML2Logic<SAML2IdPTO> {
    @Autowired
    private SAML2IdPCache cache;
    @Autowired
    private SAML2IdPDataBinder binder;
    @Autowired
    private SAML2IdPDAO idpDAO;
    @Autowired
    private SAML2SPClassPathScanImplementationLookup implLookup;
    @Autowired
    private SAML2ReaderWriter saml2rw;

    @PreAuthorize(value="isAuthenticated()")
    public Set<String> getActionsClasses() {
        return this.implLookup.getActionsClasses();
    }

    @PreAuthorize(value="isAuthenticated()")
    public Set<String> getRequestedAuthnContextProviderClasses() {
        return this.implLookup.getRequestedAuthnContextProvidersClasses();
    }

    private SAML2IdPTO complete(SAML2IdP idp, SAML2IdPTO idpTO) {
        SAML2IdPEntity idpEntity = this.cache.get(idpTO.getEntityID());
        if (idpEntity == null) {
            try {
                idpEntity = this.cache.put(idp);
            }
            catch (Exception e) {
                LOG.error("Could not build SAML 2.0 IdP with key ", (Object)idp.getEntityID(), (Object)e);
            }
        }
        idpTO.setLogoutSupported(idpEntity == null ? false : idpEntity.getSLOLocation(SAML2BindingType.POST) != null || idpEntity.getSLOLocation(SAML2BindingType.REDIRECT) != null);
        return idpTO;
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<SAML2IdPTO> list() {
        return (List)CollectionUtils.collect((Iterable)this.idpDAO.findAll(), (Transformer)new Transformer<SAML2IdP, SAML2IdPTO>(){

            public SAML2IdPTO transform(SAML2IdP input) {
                return SAML2IdPLogic.this.complete(input, SAML2IdPLogic.this.binder.getIdPTO(input));
            }
        }, new ArrayList());
    }

    @PreAuthorize(value="hasRole('IDP_READ')")
    @Transactional(readOnly=true)
    public SAML2IdPTO read(String key) {
        this.check();
        SAML2IdP idp = this.idpDAO.find(key);
        if (idp == null) {
            throw new NotFoundException("SAML 2.0 IdP '" + key + "'");
        }
        return this.complete(idp, this.binder.getIdPTO(idp));
    }

    private List<SAML2IdPTO> importIdPs(InputStream input) throws Exception {
        Object descendant;
        ArrayList<EntityDescriptor> idpEntityDescriptors = new ArrayList<EntityDescriptor>();
        Element root = OpenSAMLUtil.getParserPool().parse((Reader)new InputStreamReader(input)).getDocumentElement();
        if ("urn:oasis:names:tc:SAML:2.0:metadata".equals(root.getNamespaceURI()) && "EntityDescriptor".equals(root.getLocalName())) {
            idpEntityDescriptors.add((EntityDescriptor)OpenSAMLUtil.fromDom((Element)root));
        } else if ("urn:oasis:names:tc:SAML:2.0:metadata".equals(root.getNamespaceURI()) && "EntitiesDescriptor".equals(root.getLocalName())) {
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!"urn:oasis:names:tc:SAML:2.0:metadata".equals(child.getNamespaceURI()) || !"EntityDescriptor".equals(child.getLocalName())) continue;
                NodeList descendants = child.getChildNodes();
                for (int j = 0; j < descendants.getLength(); ++j) {
                    descendant = descendants.item(j);
                    if (!"urn:oasis:names:tc:SAML:2.0:metadata".equals(descendant.getNamespaceURI()) || !"IDPSSODescriptor".equals(descendant.getLocalName())) continue;
                    idpEntityDescriptors.add((EntityDescriptor)OpenSAMLUtil.fromDom((Element)((Element)child)));
                }
            }
        }
        ArrayList<SAML2IdPTO> result = new ArrayList<SAML2IdPTO>(idpEntityDescriptors.size());
        for (EntityDescriptor idpEntityDescriptor : idpEntityDescriptors) {
            SAML2IdPTO idpTO = new SAML2IdPTO();
            idpTO.setEntityID(idpEntityDescriptor.getEntityID());
            idpTO.setName(idpEntityDescriptor.getEntityID());
            idpTO.setUseDeflateEncoding(false);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            descendant = null;
            try {
                this.saml2rw.write(new OutputStreamWriter(baos), (XMLObject)idpEntityDescriptor, false);
                idpTO.setMetadata(Base64.encodeBase64String((byte[])baos.toByteArray()));
            }
            catch (Throwable throwable) {
                descendant = throwable;
                throw throwable;
            }
            finally {
                if (baos != null) {
                    if (descendant != null) {
                        try {
                            baos.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)descendant).addSuppressed(throwable);
                        }
                    } else {
                        baos.close();
                    }
                }
            }
            ItemTO connObjectKeyItem = new ItemTO();
            connObjectKeyItem.setIntAttrName("username");
            connObjectKeyItem.setExtAttrName("NameID");
            idpTO.setConnObjectKeyItem(connObjectKeyItem);
            SAML2IdPEntity idp = this.cache.put(idpEntityDescriptor, idpTO);
            if (idp.getSSOLocation(SAML2BindingType.POST) != null) {
                idpTO.setBindingType(SAML2BindingType.POST);
            } else if (idp.getSSOLocation(SAML2BindingType.REDIRECT) != null) {
                idpTO.setBindingType(SAML2BindingType.REDIRECT);
            } else {
                throw new IllegalArgumentException("Neither POST nor REDIRECT artifacts supported by " + idp.getId());
            }
            result.add(idpTO);
        }
        return result;
    }

    @PreAuthorize(value="hasRole('IDP_IMPORT')")
    public List<String> importFromMetadata(InputStream input) {
        this.check();
        ArrayList<String> imported = new ArrayList<String>();
        try {
            for (SAML2IdPTO idpTO : this.importIdPs(input)) {
                SAML2IdP idp = this.idpDAO.save(this.binder.create(idpTO));
                imported.add(idp.getKey());
            }
        }
        catch (SyncopeClientException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Unexpected error while importing IdP metadata", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidEntity);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return imported;
    }

    @PreAuthorize(value="hasRole('IDP_UPDATE')")
    public void update(SAML2IdPTO saml2IdpTO) {
        this.check();
        SAML2IdP saml2Idp = this.idpDAO.find(saml2IdpTO.getKey());
        if (saml2Idp == null) {
            throw new NotFoundException("SAML 2.0 IdP '" + saml2IdpTO.getKey() + "'");
        }
        SAML2IdPEntity idpEntity = this.cache.get(saml2Idp.getEntityID());
        if (idpEntity == null) {
            try {
                idpEntity = this.cache.put(saml2Idp);
            }
            catch (Exception e) {
                LOG.error("Unexpected error while updating {}", (Object)saml2Idp.getEntityID(), (Object)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidEntity);
                sce.getElements().add(e.getMessage());
                throw sce;
            }
        }
        if (idpEntity.getSSOLocation(saml2IdpTO.getBindingType()) == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidEntity);
            sce.getElements().add(saml2IdpTO.getBindingType() + " not supported by " + saml2Idp.getEntityID());
            throw sce;
        }
        saml2Idp = this.idpDAO.save(this.binder.update(saml2Idp, saml2IdpTO));
        idpEntity.setIdpTO(this.binder.getIdPTO(saml2Idp));
    }

    @PreAuthorize(value="hasRole('IDP_DELETE')")
    public void delete(String key) {
        this.check();
        SAML2IdP idp = this.idpDAO.find(key);
        if (idp == null) {
            throw new NotFoundException("SAML 2.0 IdP '" + key + "'");
        }
        this.idpDAO.delete(key);
        this.cache.remove(idp.getEntityID());
    }

    protected SAML2IdPTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof SAML2IdPTO)) continue;
                key = ((SAML2IdPTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                SAML2IdP idp = this.idpDAO.find(key);
                return this.complete(idp, this.binder.getIdPTO(idp));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

