/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.client.common.ui.panels;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.ui.commons.MapChoiceRenderer;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPasswordFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.lib.to.UserRequestFormProperty;
import org.apache.syncope.common.lib.to.UserRequestFormPropertyValue;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserRequestFormPanel
extends Panel {
    private static final long serialVersionUID = -8847854414429745216L;
    protected static final Logger LOG = LoggerFactory.getLogger(UserRequestFormPanel.class);

    public UserRequestFormPanel(String id, UserRequestForm form) {
        this(id, form, true);
    }

    public UserRequestFormPanel(String id, final UserRequestForm form, boolean showDetails) {
        super(id);
        LoadableDetachableModel<List<UserRequestFormProperty>> formProps = new LoadableDetachableModel<List<UserRequestFormProperty>>(){
            private static final long serialVersionUID = 3169142472626817508L;

            protected List<UserRequestFormProperty> load() {
                return form.getProperties();
            }
        };
        ListView<UserRequestFormProperty> propView = new ListView<UserRequestFormProperty>("propView", (IModel)formProps){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<UserRequestFormProperty> item) {
                AjaxPasswordFieldPanel field;
                final UserRequestFormProperty prop = (UserRequestFormProperty)item.getModelObject();
                String label = StringUtils.isBlank((CharSequence)prop.getName()) ? prop.getId() : prop.getName();
                switch (prop.getType()) {
                    case Boolean: {
                        field = new AjaxDropDownChoicePanel("value", label, (IModel)new PropertyModel<String>((Object)prop, "value"){
                            private static final long serialVersionUID = -3743432456095828573L;

                            public String getObject() {
                                return StringUtils.isBlank((CharSequence)prop.getValue()) ? null : (prop.getValue().equals("true") ? "Yes" : "No");
                            }

                            public void setObject(String object) {
                                prop.setValue(String.valueOf(object.equalsIgnoreCase("yes")));
                            }
                        }, false).setChoices(List.of("Yes", "No"));
                        break;
                    }
                    case Date: {
                        final FastDateFormat formatter = FastDateFormat.getInstance((String)prop.getDatePattern());
                        field = new AjaxDateTimeFieldPanel("value", label, (IModel)new PropertyModel<Date>((Object)prop, "value"){
                            private static final long serialVersionUID = -3743432456095828573L;

                            public Date getObject() {
                                try {
                                    return StringUtils.isBlank((CharSequence)prop.getValue()) ? null : formatter.parse(prop.getValue());
                                }
                                catch (ParseException e) {
                                    LOG.error("Unparsable date: {}", (Object)prop.getValue(), (Object)e);
                                    return null;
                                }
                            }

                            public void setObject(Date object) {
                                prop.setValue(formatter.format(object));
                            }
                        }, formatter);
                        break;
                    }
                    case Enum: {
                        field = new AjaxDropDownChoicePanel("value", label, (IModel)new PropertyModel((Object)prop, "value"), false).setChoiceRenderer((IChoiceRenderer)new MapChoiceRenderer(prop.getEnumValues().stream().collect(Collectors.toMap(UserRequestFormPropertyValue::getKey, UserRequestFormPropertyValue::getValue)))).setChoices(prop.getEnumValues().stream().map(UserRequestFormPropertyValue::getKey).collect(Collectors.toList()));
                        break;
                    }
                    case Dropdown: {
                        field = new AjaxDropDownChoicePanel("value", label, (IModel)new PropertyModel((Object)prop, "value"), false).setChoiceRenderer((IChoiceRenderer)new MapChoiceRenderer(prop.getDropdownValues().stream().collect(Collectors.toMap(UserRequestFormPropertyValue::getKey, UserRequestFormPropertyValue::getValue)))).setChoices(prop.getDropdownValues().stream().map(UserRequestFormPropertyValue::getKey).collect(Collectors.toList()));
                        break;
                    }
                    case Long: {
                        field = new AjaxSpinnerFieldPanel.Builder().build("value", label, Long.class, (IModel)new PropertyModel<Long>((Object)prop, "value"){
                            private static final long serialVersionUID = -7688359318035249200L;

                            public Long getObject() {
                                return StringUtils.isBlank((CharSequence)prop.getValue()) ? null : Long.valueOf(NumberUtils.toLong((String)prop.getValue()));
                            }

                            public void setObject(Long object) {
                                prop.setValue(String.valueOf(object));
                            }
                        });
                        break;
                    }
                    case Password: {
                        field = new AjaxPasswordFieldPanel("value", label, (IModel)new PropertyModel((Object)prop, "value"), false);
                        break;
                    }
                    default: {
                        field = new AjaxTextFieldPanel("value", label, (IModel)new PropertyModel((Object)prop, "value"), false);
                    }
                }
                field.setReadOnly(!prop.isWritable());
                if (prop.isRequired()) {
                    field.addRequiredLabel();
                }
                item.add(new Component[]{field});
            }
        };
        AjaxLink<String> userDetails = new AjaxLink<String>("userDetails"){
            private static final long serialVersionUID = -4804368561204623354L;

            public void onClick(AjaxRequestTarget target) {
                UserRequestFormPanel.this.viewDetails(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)userDetails, (Action)ENABLE, (String)"USER_READ");
        boolean enabled = form.getUserTO() != null;
        userDetails.setVisible(enabled && showDetails).setEnabled(enabled);
        this.add(new Component[]{propView});
        this.add(new Component[]{userDetails});
    }

    protected abstract void viewDetails(AjaxRequestTarget var1);
}

