/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.FieldSort;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch._types.query_dsl.TextQueryType;
import co.elastic.clients.elasticsearch.core.CountRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.json.JsonData;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.audit.AuditEntry;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.jpa.dao.JPAAuditConfDAO;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchUtils;
import org.springframework.util.CollectionUtils;

public class ElasticsearchAuditConfDAO
extends JPAAuditConfDAO {
    protected final ElasticsearchClient client;
    protected final int indexMaxResultWindow;

    public ElasticsearchAuditConfDAO(ElasticsearchClient client, int indexMaxResultWindow) {
        this.client = client;
        this.indexMaxResultWindow = indexMaxResultWindow;
    }

    protected Query getQuery(String entityKey, AuditElements.EventCategoryType type, String category, String subcategory, List<String> events, AuditElements.Result result, OffsetDateTime before, OffsetDateTime after) {
        List eventQueries;
        ArrayList<Query> queries = new ArrayList<Query>();
        if (entityKey != null) {
            queries.add((Query)new Query.Builder().multiMatch(QueryBuilders.multiMatch().fields("message.before", new String[]{"message.inputs", "message.output", "message.throwable"}).type(TextQueryType.Phrase).query(entityKey).build()).build());
        }
        if (type != null) {
            queries.add((Query)new Query.Builder().term(QueryBuilders.term().field("message.logger.type").value(type.name()).build()).build());
        }
        if (StringUtils.isNotBlank((CharSequence)category)) {
            queries.add((Query)new Query.Builder().term(QueryBuilders.term().field("message.logger.category").value(category).build()).build());
        }
        if (StringUtils.isNotBlank((CharSequence)subcategory)) {
            queries.add((Query)new Query.Builder().term(QueryBuilders.term().field("message.logger.subcategory").value(subcategory).build()).build());
        }
        if (!(eventQueries = events.stream().map(event -> (Query)new Query.Builder().term(QueryBuilders.term().field("message.logger.event").value(event).build()).build()).collect(Collectors.toList())).isEmpty()) {
            queries.add((Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(eventQueries).build()).build());
        }
        if (result != null) {
            queries.add((Query)new Query.Builder().term(QueryBuilders.term().field("message.logger.result").value(result.name()).build()).build());
        }
        if (before != null) {
            queries.add((Query)new Query.Builder().range(QueryBuilders.range().field("instant").lte(JsonData.of((Object)before.toInstant().toEpochMilli())).build()).build());
        }
        if (after != null) {
            queries.add((Query)new Query.Builder().range(QueryBuilders.range().field("instant").gte(JsonData.of((Object)after.toInstant().toEpochMilli())).build()).build());
        }
        return (Query)new Query.Builder().bool(QueryBuilders.bool().must(queries).build()).build();
    }

    public int countEntries(String entityKey, AuditElements.EventCategoryType type, String category, String subcategory, List<String> events, AuditElements.Result result, OffsetDateTime before, OffsetDateTime after) {
        CountRequest request = new CountRequest.Builder().index(ElasticsearchUtils.getAuditIndex((String)AuthContextUtils.getDomain()), new String[0]).query(this.getQuery(entityKey, type, category, subcategory, events, result, before, after)).build();
        try {
            return (int)this.client.count(request).count();
        }
        catch (IOException e) {
            LOG.error("Search error", (Throwable)e);
            return 0;
        }
    }

    protected List<SortOptions> sortBuilders(List<OrderByClause> orderBy) {
        return orderBy.stream().map(clause -> {
            String sortField = clause.getField();
            if ("EVENT_DATE".equalsIgnoreCase(sortField)) {
                sortField = "message.date";
            }
            return (SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(sortField).order(clause.getDirection() == OrderByClause.Direction.ASC ? SortOrder.Asc : SortOrder.Desc).build()).build();
        }).collect(Collectors.toList());
    }

    public List<AuditEntry> searchEntries(String entityKey, int page, int itemsPerPage, AuditElements.EventCategoryType type, String category, String subcategory, List<String> events, AuditElements.Result result, OffsetDateTime before, OffsetDateTime after, List<OrderByClause> orderBy) {
        SearchRequest request = new SearchRequest.Builder().index(ElasticsearchUtils.getAuditIndex((String)AuthContextUtils.getDomain()), new String[0]).searchType(SearchType.QueryThenFetch).query(this.getQuery(entityKey, type, category, subcategory, events, result, before, after)).from(Integer.valueOf(itemsPerPage * (page <= 0 ? 0 : page - 1))).size(Integer.valueOf(itemsPerPage < 0 ? this.indexMaxResultWindow : itemsPerPage)).sort(this.sortBuilders(orderBy)).build();
        List esResult = null;
        try {
            esResult = this.client.search(request, Map.class).hits().hits();
        }
        catch (Exception e) {
            LOG.error("While searching in Elasticsearch", (Throwable)e);
        }
        return CollectionUtils.isEmpty((Collection)esResult) ? List.of() : esResult.stream().map(hit -> (AuditEntry)POJOHelper.convertValue(((Map)hit.source()).get("message"), AuditEntry.class)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

