/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.FieldSort;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.DisMaxQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch.core.CountRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.json.JsonData;
import java.lang.reflect.Field;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.attrvalue.validation.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.AuxClassCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.PrivilegeCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.ResourceCond;
import org.apache.syncope.core.persistence.api.dao.search.RoleCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.jpa.dao.AbstractAnySearchDAO;
import org.apache.syncope.core.provisioning.api.utils.FormatUtils;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchUtils;
import org.springframework.util.CollectionUtils;

public class ElasticsearchAnySearchDAO
extends AbstractAnySearchDAO {
    protected static final char[] ELASTICSEARCH_REGEX_CHARS = new char[]{'.', '?', '+', '*', '|', '{', '}', '[', ']', '(', ')', '\"', '\\', '&'};
    protected final ElasticsearchClient client;
    protected final int indexMaxResultWindow;

    protected static String escapeForLikeRegex(char c) {
        StringBuilder output = new StringBuilder();
        if (ArrayUtils.contains((char[])ELASTICSEARCH_REGEX_CHARS, (char)c)) {
            output.append('\\');
        }
        output.append(c);
        return output.toString();
    }

    public ElasticsearchAnySearchDAO(RealmDAO realmDAO, DynRealmDAO dynRealmDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO schemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, ElasticsearchClient client, int indexMaxResultWindow) {
        super(realmDAO, dynRealmDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator);
        this.client = client;
        this.indexMaxResultWindow = indexMaxResultWindow;
    }

    protected Triple<Optional<Query>, Set<String>, Set<String>> getAdminRealmsFilter(Realm base, boolean recursive, Set<String> adminRealms, AnyTypeKind kind) {
        HashSet dynRealmKeys = new HashSet();
        HashSet groupOwners = new HashSet();
        ArrayList<Query> queries = new ArrayList<Query>();
        if (recursive) {
            adminRealms.forEach(realmPath -> {
                Optional goRealm = RealmUtils.parseGroupOwnerRealm((String)realmPath);
                if (goRealm.isPresent()) {
                    groupOwners.add((String)((Pair)goRealm.get()).getRight());
                } else if (realmPath.startsWith("/")) {
                    Realm realm = Optional.ofNullable(this.realmDAO.findByFullPath(realmPath)).orElseThrow(() -> {
                        SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
                        noRealm.getElements().add("Invalid realm specified: " + realmPath);
                        return noRealm;
                    });
                    this.realmDAO.findDescendants(realm.getFullPath(), null, -1, -1).stream().filter(r -> r.getFullPath().startsWith(base.getFullPath())).forEach(descendant -> queries.add((Query)new Query.Builder().term(QueryBuilders.term().field("realm").value(descendant.getKey()).build()).build()));
                } else {
                    DynRealm dynRealm = this.dynRealmDAO.find(realmPath);
                    if (dynRealm == null) {
                        LOG.warn("Ignoring invalid dynamic realm {}", realmPath);
                    } else {
                        dynRealmKeys.add(dynRealm.getKey());
                        queries.add((Query)new Query.Builder().term(QueryBuilders.term().field("dynRealm").value(dynRealm.getKey()).build()).build());
                    }
                }
            });
        } else if (adminRealms.stream().anyMatch(r -> r.startsWith(base.getFullPath()))) {
            queries.add((Query)new Query.Builder().term(QueryBuilders.term().field("realm").value(base.getKey()).build()).build());
        }
        return Triple.of(dynRealmKeys.isEmpty() && groupOwners.isEmpty() ? Optional.of((Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(queries).build()).build()) : Optional.empty(), dynRealmKeys, groupOwners);
    }

    protected Query getQuery(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        Query query;
        if (SyncopeConstants.FULL_ADMIN_REALMS.equals(adminRealms)) {
            query = this.getQuery(cond, kind);
            if (!recursive) {
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().must((Query)new Query.Builder().term(QueryBuilders.term().field("realm").value(base.getKey()).build()).build(), new Query[0]).must(query, new Query[0]).build()).build();
            }
        } else {
            Triple<Optional<Query>, Set<String>, Set<String>> filter = this.getAdminRealmsFilter(base, recursive, adminRealms, kind);
            query = this.getQuery(ElasticsearchAnySearchDAO.buildEffectiveCond((SearchCond)cond, (Set)((Set)filter.getMiddle()), (Set)((Set)filter.getRight()), (AnyTypeKind)kind), kind);
            if (((Optional)filter.getLeft()).isPresent()) {
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().must((Query)((Optional)filter.getLeft()).get(), new Query[0]).must(query, new Query[0]).build()).build();
            }
        }
        return query;
    }

    protected int doCount(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        CountRequest request = new CountRequest.Builder().index(ElasticsearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)kind), new String[0]).query(this.getQuery(base, recursive, adminRealms, cond, kind)).build();
        LOG.debug("Count JSON request: {}", (Object)request);
        try {
            return (int)this.client.count(request).count();
        }
        catch (Exception e) {
            LOG.error("While counting in Elasticsearch", (Throwable)e);
            return 0;
        }
    }

    protected List<SortOptions> sortBuilders(AnyTypeKind kind, List<OrderByClause> orderBy) {
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(kind);
        ArrayList<SortOptions> options = new ArrayList<SortOptions>();
        orderBy.forEach(clause -> {
            String sortName = null;
            String fieldName = "key".equals(clause.getField()) ? "id" : clause.getField();
            Field anyField = anyUtils.getField(fieldName);
            if (anyField == null) {
                PlainSchema schema = (PlainSchema)this.plainSchemaDAO.find(fieldName);
                if (schema != null) {
                    sortName = fieldName;
                }
            } else {
                sortName = fieldName;
            }
            if (sortName == null) {
                LOG.warn("Cannot build any valid clause from {}", clause);
            } else {
                options.add((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(sortName).order(clause.getDirection() == OrderByClause.Direction.ASC ? SortOrder.Asc : SortOrder.Desc).build()).build());
            }
        });
        return options;
    }

    protected <T extends Any<?>> List<T> doSearch(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, int page, int itemsPerPage, List<OrderByClause> orderBy, AnyTypeKind kind) {
        SearchRequest request = new SearchRequest.Builder().index(ElasticsearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)kind), new String[0]).searchType(SearchType.QueryThenFetch).query(this.getQuery(base, recursive, adminRealms, cond, kind)).from(Integer.valueOf(itemsPerPage * (page <= 0 ? 0 : page - 1))).size(Integer.valueOf(itemsPerPage < 0 ? this.indexMaxResultWindow : itemsPerPage)).sort(this.sortBuilders(kind, orderBy)).build();
        LOG.debug("Search JSON request: {}", (Object)request);
        List esResult = null;
        try {
            esResult = this.client.search(request, Map.class).hits().hits();
        }
        catch (Exception e) {
            LOG.error("While searching in Elasticsearch", (Throwable)e);
        }
        return CollectionUtils.isEmpty((Collection)esResult) ? List.of() : this.buildResult(esResult.stream().map(Hit::id).collect(Collectors.toList()), kind);
    }

    protected Query getQuery(SearchCond cond, AnyTypeKind kind) {
        Query query = null;
        switch (cond.getType()) {
            case LEAF: 
            case NOT_LEAF: {
                query = cond.getLeaf(AnyTypeCond.class).filter(leaf -> AnyTypeKind.ANY_OBJECT == kind).map(this::getQuery).orElse(null);
                if (query == null) {
                    query = cond.getLeaf(RelationshipTypeCond.class).filter(leaf -> AnyTypeKind.GROUP != kind).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.getLeaf(RelationshipCond.class).filter(leaf -> AnyTypeKind.GROUP != kind).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.getLeaf(MembershipCond.class).filter(leaf -> AnyTypeKind.GROUP != kind).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.getLeaf(MemberCond.class).filter(leaf -> AnyTypeKind.GROUP == kind).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.getLeaf(RoleCond.class).filter(leaf -> AnyTypeKind.USER == kind).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.getLeaf(PrivilegeCond.class).filter(leaf -> AnyTypeKind.USER == kind).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.getLeaf(DynRealmCond.class).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.getLeaf(AuxClassCond.class).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.getLeaf(ResourceCond.class).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.getLeaf(AnyCond.class).map(ac -> this.getQuery((AnyCond)ac, kind)).or(() -> cond.getLeaf(AttrCond.class).map(ac -> this.getQuery((AttrCond)ac, kind))).orElse(null);
                }
                if (query == null) {
                    query = this.getQueryForCustomConds(cond, kind);
                }
                if (query == null) {
                    throw new IllegalArgumentException("Cannot construct QueryBuilder");
                }
                if (cond.getType() != SearchCond.Type.NOT_LEAF) break;
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().mustNot(query, new Query[0]).build()).build();
                break;
            }
            case AND: {
                ArrayList<Query> andCompound = new ArrayList<Query>();
                Query andLeft = this.getQuery(cond.getLeft(), kind);
                if (andLeft._kind() == Query.Kind.Bool && !((BoolQuery)andLeft._get()).must().isEmpty()) {
                    andCompound.addAll(((BoolQuery)andLeft._get()).must());
                } else {
                    andCompound.add(andLeft);
                }
                Query andRight = this.getQuery(cond.getRight(), kind);
                if (andRight._kind() == Query.Kind.Bool && !((BoolQuery)andRight._get()).must().isEmpty()) {
                    andCompound.addAll(((BoolQuery)andRight._get()).must());
                } else {
                    andCompound.add(andRight);
                }
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().must(andCompound).build()).build();
                break;
            }
            case OR: {
                ArrayList<Query> orCompound = new ArrayList<Query>();
                Query orLeft = this.getQuery(cond.getLeft(), kind);
                if (orLeft._kind() == Query.Kind.DisMax) {
                    orCompound.addAll(((DisMaxQuery)orLeft._get()).queries());
                } else {
                    orCompound.add(orLeft);
                }
                Query orRight = this.getQuery(cond.getRight(), kind);
                if (orRight._kind() == Query.Kind.DisMax) {
                    orCompound.addAll(((DisMaxQuery)orRight._get()).queries());
                } else {
                    orCompound.add(orRight);
                }
                query = (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(orCompound).build()).build();
                break;
            }
        }
        return query;
    }

    protected Query getQuery(AnyTypeCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("anyType").value(cond.getAnyTypeKey()).build()).build();
    }

    protected Query getQuery(RelationshipTypeCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("relationshipTypes").value(cond.getRelationshipTypeKey()).build()).build();
    }

    protected Query getQuery(RelationshipCond cond) {
        List queries = this.check(cond).stream().map(key -> (Query)new Query.Builder().term(QueryBuilders.term().field("relationships").value(key).build()).build()).collect(Collectors.toList());
        return queries.size() == 1 ? (Query)queries.get(0) : (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(queries).build()).build();
    }

    protected Query getQuery(MembershipCond cond) {
        List queries = this.check(cond).stream().map(key -> (Query)new Query.Builder().term(QueryBuilders.term().field("memberships").value(key).build()).build()).collect(Collectors.toList());
        return queries.size() == 1 ? (Query)queries.get(0) : (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(queries).build()).build();
    }

    protected Query getQuery(RoleCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("roles").value(cond.getRole()).build()).build();
    }

    protected Query getQuery(PrivilegeCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("privileges").value(cond.getPrivilege()).build()).build();
    }

    protected Query getQuery(DynRealmCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("dynRealms").value(cond.getDynRealm()).build()).build();
    }

    protected Query getQuery(MemberCond cond) {
        List queries = this.check(cond).stream().map(key -> (Query)new Query.Builder().term(QueryBuilders.term().field("members").value(key).build()).build()).collect(Collectors.toList());
        return queries.size() == 1 ? (Query)queries.get(0) : (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(queries).build()).build();
    }

    protected Query getQuery(AuxClassCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("auxClasses").value(cond.getAuxClass()).build()).build();
    }

    protected Query getQuery(ResourceCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("resources").value(cond.getResource()).build()).build();
    }

    protected Query fillAttrQuery(PlainSchema schema, PlainAttrValue attrValue, AttrCond cond) {
        Object value = schema.getType() == AttrSchemaType.Date && attrValue.getDateValue() != null ? FormatUtils.format((TemporalAccessor)attrValue.getDateValue()) : attrValue.getValue();
        Query query = null;
        switch (cond.getType()) {
            case ISNOTNULL: {
                query = (Query)new Query.Builder().exists(QueryBuilders.exists().field(schema.getKey()).build()).build();
                break;
            }
            case ISNULL: {
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().mustNot((Query)new Query.Builder().exists(QueryBuilders.exists().field(schema.getKey()).build()).build(), new Query[0]).build()).build();
                break;
            }
            case ILIKE: {
                StringBuilder output = new StringBuilder();
                for (char c : cond.getExpression().toLowerCase().toCharArray()) {
                    if (c == '%') {
                        output.append(".*");
                        continue;
                    }
                    if (Character.isLetter(c)) {
                        output.append('[').append(c).append(Character.toUpperCase(c)).append(']');
                        continue;
                    }
                    output.append(ElasticsearchAnySearchDAO.escapeForLikeRegex(c));
                }
                query = (Query)new Query.Builder().regexp(QueryBuilders.regexp().field(schema.getKey()).value(output.toString()).build()).build();
                break;
            }
            case LIKE: {
                query = (Query)new Query.Builder().wildcard(QueryBuilders.wildcard().field(schema.getKey()).value(cond.getExpression().replace('%', '*')).build()).build();
                break;
            }
            case IEQ: {
                query = (Query)new Query.Builder().match(QueryBuilders.match().field(schema.getKey()).query(cond.getExpression().toLowerCase()).build()).build();
                break;
            }
            case EQ: {
                FieldValue fieldValue = value instanceof Double ? FieldValue.of((double)((Double)value)) : (value instanceof Long ? FieldValue.of((long)((Long)value)) : (value instanceof Boolean ? FieldValue.of((boolean)((Boolean)value)) : FieldValue.of((String)value.toString())));
                query = (Query)new Query.Builder().term(QueryBuilders.term().field(schema.getKey()).value(fieldValue).build()).build();
                break;
            }
            case GE: {
                query = (Query)new Query.Builder().range(QueryBuilders.range().field(schema.getKey()).gte(JsonData.of((Object)value)).build()).build();
                break;
            }
            case GT: {
                query = (Query)new Query.Builder().range(QueryBuilders.range().field(schema.getKey()).gt(JsonData.of((Object)value)).build()).build();
                break;
            }
            case LE: {
                query = (Query)new Query.Builder().range(QueryBuilders.range().field(schema.getKey()).lte(JsonData.of((Object)value)).build()).build();
                break;
            }
            case LT: {
                query = (Query)new Query.Builder().range(QueryBuilders.range().field(schema.getKey()).lt(JsonData.of((Object)value)).build()).build();
                break;
            }
        }
        return query;
    }

    protected Query getQuery(AttrCond cond, AnyTypeKind kind) {
        Pair checked = this.check(cond, kind);
        return this.fillAttrQuery((PlainSchema)checked.getLeft(), (PlainAttrValue)checked.getRight(), cond);
    }

    protected Query getQuery(AnyCond cond, AnyTypeKind kind) {
        if ("realm".equals(cond.getSchema()) && cond.getExpression().startsWith("/")) {
            Realm realm = Optional.ofNullable(this.realmDAO.findByFullPath(cond.getExpression())).orElseThrow(() -> new IllegalArgumentException("Invalid Realm full path: " + cond.getExpression()));
            cond.setExpression(realm.getKey());
        }
        Triple checked = this.check(cond, kind);
        return this.fillAttrQuery((PlainSchema)checked.getLeft(), (PlainAttrValue)checked.getMiddle(), (AttrCond)checked.getRight());
    }

    protected Query getQueryForCustomConds(SearchCond cond, AnyTypeKind kind) {
        return null;
    }
}

