/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.AssignableCond;
import org.apache.syncope.core.persistence.api.dao.search.AttributeCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.ResourceCond;
import org.apache.syncope.core.persistence.api.dao.search.RoleCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.jpa.dao.AbstractAnySearchDAO;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchUtils;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ReflectionUtils;

public class ElasticsearchAnySearchDAO
extends AbstractAnySearchDAO {
    private static final QueryBuilder EMPTY_QUERY_BUILDER = new MatchNoneQueryBuilder();
    @Autowired
    private Client client;
    @Autowired
    private ElasticsearchUtils elasticsearchUtils;

    private Pair<DisMaxQueryBuilder, Set<String>> adminRealmsFilter(Set<String> adminRealms) {
        DisMaxQueryBuilder builder = QueryBuilders.disMaxQuery();
        HashSet<String> dynRealmKeys = new HashSet<String>();
        for (String realmPath : RealmUtils.normalize(adminRealms)) {
            if (realmPath.startsWith("/")) {
                Realm realm = this.realmDAO.findByFullPath(realmPath);
                if (realm == null) {
                    SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
                    noRealm.getElements().add("Invalid realm specified: " + realmPath);
                    throw noRealm;
                }
                for (Realm descendant : this.realmDAO.findDescendants(realm)) {
                    builder.add((QueryBuilder)QueryBuilders.termQuery((String)"realm", (String)descendant.getFullPath()));
                }
                continue;
            }
            DynRealm dynRealm = this.dynRealmDAO.find(realmPath);
            if (dynRealm == null) {
                LOG.warn("Ignoring invalid dynamic realm {}", (Object)realmPath);
                continue;
            }
            dynRealmKeys.add(dynRealm.getKey());
            builder.add((QueryBuilder)QueryBuilders.termQuery((String)"dynRealm", (String)dynRealm.getKey()));
        }
        if (!dynRealmKeys.isEmpty()) {
            for (Realm descendant : this.realmDAO.findAll()) {
                builder.add((QueryBuilder)QueryBuilders.termQuery((String)"realm", (String)descendant.getFullPath()));
            }
        }
        return Pair.of((Object)builder, dynRealmKeys);
    }

    private SearchRequestBuilder searchRequestBuilder(Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        Pair<DisMaxQueryBuilder, Set<String>> filter = this.adminRealmsFilter(adminRealms);
        return this.client.prepareSearch(new String[]{AuthContextUtils.getDomain().toLowerCase()}).setTypes(new String[]{kind.name()}).setSearchType(SearchType.QUERY_THEN_FETCH).setQuery((QueryBuilder)(SyncopeConstants.FULL_ADMIN_REALMS.equals(adminRealms) ? this.getQueryBuilder(cond, kind) : QueryBuilders.boolQuery().must((QueryBuilder)filter.getLeft()).must(this.getQueryBuilder(this.buildEffectiveCond(cond, (Set)filter.getRight()), kind))));
    }

    protected int doCount(Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        SearchRequestBuilder builder = this.searchRequestBuilder(adminRealms, cond, kind).setFrom(0).setSize(0);
        return (int)((SearchResponse)builder.get()).getHits().getTotalHits();
    }

    private void addSort(SearchRequestBuilder builder, AnyTypeKind kind, List<OrderByClause> orderBy) {
        AnyUtils attrUtils = this.anyUtilsFactory.getInstance(kind);
        for (OrderByClause clause : this.filterOrderBy(orderBy)) {
            String sortName = null;
            String fieldName = "key".equals(clause.getField()) ? "id" : clause.getField();
            Field anyField = ReflectionUtils.findField((Class)attrUtils.anyClass(), (String)fieldName);
            if (anyField == null) {
                PlainSchema schema = (PlainSchema)this.schemaDAO.find(fieldName);
                if (schema != null) {
                    sortName = fieldName;
                }
            } else {
                sortName = fieldName;
            }
            if (sortName == null) {
                LOG.warn("Cannot build any valid clause from {}", (Object)clause);
                continue;
            }
            builder.addSort(sortName, SortOrder.valueOf((String)clause.getDirection().name()));
        }
    }

    protected <T extends Any<?>> List<T> doSearch(Set<String> adminRealms, SearchCond cond, int page, int itemsPerPage, List<OrderByClause> orderBy, AnyTypeKind kind) {
        SearchRequestBuilder builder = this.searchRequestBuilder(adminRealms, cond, kind).setFrom(page <= 0 ? 0 : page - 1).setSize(itemsPerPage < 0 ? this.elasticsearchUtils.getIndexMaxResultWindow() : itemsPerPage);
        this.addSort(builder, kind, orderBy);
        return this.buildResult((List)CollectionUtils.collect(Arrays.asList(((SearchResponse)builder.get()).getHits().getHits()), (Transformer)new Transformer<SearchHit, Object>(){

            public Object transform(SearchHit input) {
                return input.getId();
            }
        }, new ArrayList()), kind);
    }

    private QueryBuilder getQueryBuilder(SearchCond cond, AnyTypeKind kind) {
        QueryBuilder builder = EMPTY_QUERY_BUILDER;
        switch (cond.getType()) {
            case LEAF: 
            case NOT_LEAF: {
                if (cond.getAnyTypeCond() != null && AnyTypeKind.ANY_OBJECT == kind) {
                    builder = this.getQueryBuilder(cond.getAnyTypeCond());
                } else if (cond.getRelationshipTypeCond() != null && (AnyTypeKind.USER == kind || AnyTypeKind.ANY_OBJECT == kind)) {
                    builder = this.getQueryBuilder(cond.getRelationshipTypeCond());
                } else if (cond.getRelationshipCond() != null && (AnyTypeKind.USER == kind || AnyTypeKind.ANY_OBJECT == kind)) {
                    builder = this.getQueryBuilder(cond.getRelationshipCond());
                } else if (cond.getMembershipCond() != null && (AnyTypeKind.USER == kind || AnyTypeKind.ANY_OBJECT == kind)) {
                    builder = this.getQueryBuilder(cond.getMembershipCond());
                } else if (cond.getAssignableCond() != null) {
                    builder = this.getQueryBuilder(cond.getAssignableCond());
                } else if (cond.getRoleCond() != null && AnyTypeKind.USER == kind) {
                    builder = this.getQueryBuilder(cond.getRoleCond());
                } else if (cond.getDynRealmCond() != null) {
                    builder = this.getQueryBuilder(cond.getDynRealmCond());
                } else if (cond.getMemberCond() != null && AnyTypeKind.GROUP == kind) {
                    builder = this.getQueryBuilder(cond.getMemberCond());
                } else if (cond.getResourceCond() != null) {
                    builder = this.getQueryBuilder(cond.getResourceCond());
                } else if (cond.getAttributeCond() != null) {
                    builder = this.getQueryBuilder(cond.getAttributeCond(), kind);
                } else if (cond.getAnyCond() != null) {
                    builder = this.getQueryBuilder(cond.getAnyCond(), kind);
                }
                builder = this.checkNot(builder, cond.getType() == SearchCond.Type.NOT_LEAF);
                break;
            }
            case AND: {
                builder = QueryBuilders.boolQuery().must(this.getQueryBuilder(cond.getLeftSearchCond(), kind)).must(this.getQueryBuilder(cond.getRightSearchCond(), kind));
                break;
            }
            case OR: {
                builder = QueryBuilders.disMaxQuery().add(this.getQueryBuilder(cond.getLeftSearchCond(), kind)).add(this.getQueryBuilder(cond.getRightSearchCond(), kind));
                break;
            }
        }
        return builder;
    }

    private QueryBuilder checkNot(QueryBuilder builder, boolean not) {
        return not ? QueryBuilders.boolQuery().mustNot(builder) : builder;
    }

    private QueryBuilder getQueryBuilder(AnyTypeCond cond) {
        return QueryBuilders.termQuery((String)"anyType", (String)cond.getAnyTypeKey());
    }

    private QueryBuilder getQueryBuilder(RelationshipTypeCond cond) {
        return QueryBuilders.termQuery((String)"relationshipTypes", (String)cond.getRelationshipTypeKey());
    }

    private QueryBuilder getQueryBuilder(RelationshipCond cond) {
        String rightAnyObjectKey;
        try {
            rightAnyObjectKey = this.check(cond);
        }
        catch (IllegalArgumentException e) {
            return EMPTY_QUERY_BUILDER;
        }
        return QueryBuilders.termQuery((String)"relationships", (String)rightAnyObjectKey);
    }

    private QueryBuilder getQueryBuilder(MembershipCond cond) {
        String groupKey;
        try {
            groupKey = this.check(cond);
        }
        catch (IllegalArgumentException e) {
            return EMPTY_QUERY_BUILDER;
        }
        return QueryBuilders.termQuery((String)"memberships", (String)groupKey);
    }

    private QueryBuilder getQueryBuilder(AssignableCond cond) {
        Realm realm;
        try {
            realm = this.check(cond);
        }
        catch (IllegalArgumentException e) {
            return EMPTY_QUERY_BUILDER;
        }
        DisMaxQueryBuilder builder = QueryBuilders.disMaxQuery();
        if (cond.isFromGroup()) {
            for (Realm current : this.realmDAO.findDescendants(realm)) {
                builder.add((QueryBuilder)QueryBuilders.termQuery((String)"realm", (String)current.getFullPath()));
            }
        } else {
            Realm current = realm;
            while (current.getParent() != null) {
                builder.add((QueryBuilder)QueryBuilders.termQuery((String)"realm", (String)current.getFullPath()));
                current = current.getParent();
            }
            builder.add((QueryBuilder)QueryBuilders.termQuery((String)"realm", (String)this.realmDAO.getRoot().getFullPath()));
        }
        return builder;
    }

    private QueryBuilder getQueryBuilder(RoleCond cond) {
        return QueryBuilders.termQuery((String)"roles", (String)cond.getRole());
    }

    private QueryBuilder getQueryBuilder(DynRealmCond cond) {
        return QueryBuilders.termQuery((String)"dynRealms", (String)cond.getDynRealm());
    }

    private QueryBuilder getQueryBuilder(MemberCond cond) {
        String memberKey;
        try {
            memberKey = this.check(cond);
        }
        catch (IllegalArgumentException e) {
            return EMPTY_QUERY_BUILDER;
        }
        return QueryBuilders.termQuery((String)"members", (String)memberKey);
    }

    private QueryBuilder getQueryBuilder(ResourceCond cond) {
        return QueryBuilders.termQuery((String)"resources", (String)cond.getResourceKey());
    }

    private QueryBuilder fillAttrQuery(PlainSchema schema, PlainAttrValue attrValue, AttributeCond cond) {
        Object value = schema.getType() == AttrSchemaType.Date && attrValue.getDateValue() != null ? Long.valueOf(attrValue.getDateValue().getTime()) : attrValue.getValue();
        QueryBuilder builder = EMPTY_QUERY_BUILDER;
        switch (cond.getType()) {
            case ISNOTNULL: {
                builder = QueryBuilders.existsQuery((String)schema.getKey());
                break;
            }
            case ISNULL: {
                builder = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)schema.getKey()));
                break;
            }
            case ILIKE: {
                builder = QueryBuilders.queryStringQuery((String)(schema.getKey() + ":" + cond.getExpression().replace('%', '*').toLowerCase()));
                break;
            }
            case LIKE: {
                builder = QueryBuilders.wildcardQuery((String)schema.getKey(), (String)cond.getExpression().replace('%', '*'));
                break;
            }
            case IEQ: {
                builder = QueryBuilders.matchQuery((String)schema.getKey(), (Object)cond.getExpression().toLowerCase());
                break;
            }
            case EQ: {
                builder = QueryBuilders.termQuery((String)schema.getKey(), (Object)value);
                break;
            }
            case GE: {
                builder = QueryBuilders.rangeQuery((String)schema.getKey()).gte(value);
                break;
            }
            case GT: {
                builder = QueryBuilders.rangeQuery((String)schema.getKey()).gt(value);
                break;
            }
            case LE: {
                builder = QueryBuilders.rangeQuery((String)schema.getKey()).lte(value);
                break;
            }
            case LT: {
                builder = QueryBuilders.rangeQuery((String)schema.getKey()).lt(value);
                break;
            }
        }
        return builder;
    }

    private QueryBuilder getQueryBuilder(AttributeCond cond, AnyTypeKind kind) {
        Pair checked;
        try {
            checked = this.check(cond, kind);
        }
        catch (IllegalArgumentException e) {
            return EMPTY_QUERY_BUILDER;
        }
        return this.fillAttrQuery((PlainSchema)checked.getLeft(), (PlainAttrValue)checked.getRight(), cond);
    }

    private QueryBuilder getQueryBuilder(AnyCond cond, AnyTypeKind kind) {
        Triple checked;
        try {
            checked = this.check(cond, kind);
        }
        catch (IllegalArgumentException e) {
            return EMPTY_QUERY_BUILDER;
        }
        return this.fillAttrQuery((PlainSchema)checked.getLeft(), (PlainAttrValue)checked.getMiddle(), (AttributeCond)checked.getRight());
    }
}

