/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.syncope.common.lib.to.CamelMetrics;
import org.apache.syncope.common.lib.to.CamelRouteTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Camel")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="camelRoutes")
public interface CamelRouteService
extends JAXRSService {
    @GET
    @Path(value="{anyTypeKind}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<CamelRouteTO> list(@NotNull @PathParam(value="anyTypeKind") AnyTypeKind var1);

    @GET
    @Path(value="{anyTypeKind}/{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public CamelRouteTO read(@NotNull @PathParam(value="anyTypeKind") AnyTypeKind var1, @NotNull @PathParam(value="key") String var2);

    @Parameter(name="key", description="Camel route's key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @PUT
    @Path(value="{anyTypeKind}/{key}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void update(@NotNull @PathParam(value="anyTypeKind") AnyTypeKind var1, @NotNull CamelRouteTO var2);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="restartContext")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void restartContext();

    @GET
    @Path(value="metrics")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public CamelMetrics metrics();
}

