/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.SAML2SPEntityRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.SAML2SPEntityWizardBuilder;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.ModalPanelBuilder;
import org.apache.syncope.common.lib.to.SAML2SPEntityTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public class SAML2SPEntityDirectoryPanel
extends DirectoryPanel<SAML2SPEntityTO, SAML2SPEntityTO, SAML2SPEntityProvider, SAML2SPEntityRestClient> {
    private static final long serialVersionUID = -3890622383545171017L;
    private final String waPrefix;

    public SAML2SPEntityDirectoryPanel(String id, SAML2SPEntityRestClient restClient, String waPrefix, PageReference pageRef) {
        super(id, (RestClient)restClient, pageRef);
        this.waPrefix = waPrefix;
        this.disableCheckBoxes();
        this.modal.size(Modal.Size.Large);
        this.modal.addSubmitButton();
        this.modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            this.updateResultTable(target);
            this.modal.show(false);
        });
        this.addNewItemPanelBuilder((ModalPanelBuilder)new SAML2SPEntityWizardBuilder(new SAML2SPEntityTO(), restClient, pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"SAML2_SP_ENTITY_SET");
        this.initResultTable();
    }

    protected List<IColumn<SAML2SPEntityTO, String>> getColumns() {
        ArrayList<IColumn<SAML2SPEntityTO, String>> columns = new ArrayList<IColumn<SAML2SPEntityTO, String>>();
        columns.add((IColumn<SAML2SPEntityTO, String>)new PropertyColumn((IModel)new StringResourceModel("key", (Component)this), (Object)"key", "key"));
        columns.add((IColumn<SAML2SPEntityTO, String>)new AbstractColumn<SAML2SPEntityTO, String>((IModel)Model.of((Serializable)((Object)"URL"))){
            private static final long serialVersionUID = -7226955670801277153L;

            public void populateItem(Item<ICellPopulator<SAML2SPEntityTO>> cellItem, String componentId, IModel<SAML2SPEntityTO> rowModel) {
                final String metadataURL = SAML2SPEntityDirectoryPanel.this.waPrefix + "/sp/" + ((SAML2SPEntityTO)rowModel.getObject()).getKey() + "/metadata";
                cellItem.add(new Component[]{new ExternalLink(componentId, (IModel)Model.of((Serializable)((Object)metadataURL)), (IModel)Model.of((Serializable)((Object)metadataURL))){
                    private static final long serialVersionUID = -1919646533527005367L;

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                        tag.setName("a");
                        if (metadataURL.startsWith("http")) {
                            tag.put("href", (CharSequence)this.getDefaultModelObject().toString());
                            tag.put("target", (CharSequence)"_blank");
                        }
                    }
                }});
            }
        });
        return columns;
    }

    protected ActionsPanel<SAML2SPEntityTO> getActions(final IModel<SAML2SPEntityTO> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<SAML2SPEntityTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, SAML2SPEntityTO ignore) {
                SAML2SPEntityDirectoryPanel.this.send((IEventSink)SAML2SPEntityDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((SAML2SPEntityRestClient)SAML2SPEntityDirectoryPanel.this.restClient).get(((SAML2SPEntityTO)model.getObject()).getKey()), target));
            }
        }, ActionLink.ActionType.EDIT, "SAML2_SP_ENTITY_SET");
        panel.add((ActionLink)new ActionLink<SAML2SPEntityTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, SAML2SPEntityTO ignore) {
                try {
                    ((SAML2SPEntityRestClient)SAML2SPEntityDirectoryPanel.this.restClient).delete(((SAML2SPEntityTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)SAML2SPEntityDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{SAML2SPEntityDirectoryPanel.this.container});
                }
                catch (Exception e) {
                    DirectoryPanel.LOG.error("While deleting {}", (Object)((SAML2SPEntityTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BaseWebPage)SAML2SPEntityDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "AUTH_MODULE_DELETE", true);
        return panel;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected SAML2SPEntityProvider dataProvider() {
        return new SAML2SPEntityProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "saml2spentity.properties.paginator.rows";
    }

    protected final class SAML2SPEntityProvider
    extends DirectoryDataProvider<SAML2SPEntityTO> {
        private static final long serialVersionUID = 5282134321828253058L;
        private final SortableDataProviderComparator<SAML2SPEntityTO> comparator;

        public SAML2SPEntityProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("key", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator((SortableDataProvider)this);
        }

        public Iterator<? extends SAML2SPEntityTO> iterator(long first, long count) {
            List<SAML2SPEntityTO> list = ((SAML2SPEntityRestClient)SAML2SPEntityDirectoryPanel.this.restClient).list();
            list.sort((Comparator<SAML2SPEntityTO>)this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((SAML2SPEntityRestClient)SAML2SPEntityDirectoryPanel.this.restClient).list().size();
        }

        public IModel<SAML2SPEntityTO> model(SAML2SPEntityTO metadata) {
            return new CompoundPropertyModel((Object)metadata);
        }
    }
}

