/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.syncope.client.console.rest.SAML2SPEntityRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.client.console.wizards.SAML2EntityWizardBuilder;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.to.SAML2EntityTO;
import org.apache.syncope.common.lib.to.SAML2SPEntityTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class SAML2SPEntityWizardBuilder
extends SAML2EntityWizardBuilder<SAML2SPEntityTO> {
    private static final long serialVersionUID = 1L;

    public SAML2SPEntityWizardBuilder(SAML2SPEntityTO defaultItem, PageReference pageRef) {
        super(defaultItem, pageRef);
    }

    protected Serializable onApplyInternal(SAML2SPEntityTO modelObject) {
        if (modelObject.getMetadata() != null) {
            modelObject.setMetadata(Base64.getEncoder().encodeToString(modelObject.getMetadata().getBytes(StandardCharsets.UTF_8)));
        }
        SAML2SPEntityRestClient.set(modelObject);
        return modelObject;
    }

    protected WizardModel buildModelSteps(SAML2SPEntityTO modelObject, WizardModel wizardModel) {
        if (modelObject.getMetadata() != null) {
            modelObject.setMetadata(new String(Base64.getDecoder().decode(modelObject.getMetadata()), StandardCharsets.UTF_8));
        }
        wizardModel.add((IWizardStep)new Profile(modelObject, this.mode == AjaxWizard.Mode.CREATE));
        wizardModel.add((IWizardStep)new SAML2EntityWizardBuilder.Metadata((SAML2EntityWizardBuilder)this, (SAML2EntityTO)modelObject, this.pageRef));
        wizardModel.add((IWizardStep)new BinaryPem(modelObject, "keystore", this.pageRef));
        return wizardModel;
    }

    protected class BinaryPem
    extends SAML2EntityWizardBuilder.Pem {
        private static final long serialVersionUID = 1L;

        public BinaryPem(SAML2SPEntityTO entity, String property, final PageReference pageRef) {
            super(property);
            this.add(new Component[]{new BinaryFieldPanel("content", "", (IModel)new PropertyModel((Object)entity, property), "application/octet-stream", entity.getKey()){
                private static final long serialVersionUID = -3268213909514986831L;

                protected PageReference getPageReference() {
                    return pageRef;
                }
            }});
        }
    }

    protected static class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;

        Profile(SAML2SPEntityTO entity, boolean isNew) {
            AjaxTextFieldPanel key = new AjaxTextFieldPanel("key", "key", (IModel)new PropertyModel((Object)entity, "key"));
            key.addRequiredLabel();
            key.setEnabled(isNew);
            this.add(new Component[]{key});
        }
    }
}

