/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.client.console.panels.SRARouteFilterPanel;
import org.apache.syncope.client.console.panels.SRARoutePredicatePanel;
import org.apache.syncope.client.console.rest.SRARouteRestClient;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.SRARouteTO;
import org.apache.syncope.common.lib.types.SRARouteFilter;
import org.apache.syncope.common.lib.types.SRARoutePredicate;
import org.apache.syncope.common.lib.types.SRARouteType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;

public class SRARouteWizardBuilder
extends BaseAjaxWizardBuilder<SRARouteTO> {
    private static final long serialVersionUID = 2060352959114706419L;

    public SRARouteWizardBuilder(SRARouteTO route, PageReference pageRef) {
        super((Serializable)route, pageRef);
    }

    protected Serializable onApplyInternal(SRARouteTO modelObject) {
        if (modelObject.getKey() == null) {
            SRARouteRestClient.create(modelObject);
        } else {
            SRARouteRestClient.update(modelObject);
        }
        return modelObject;
    }

    protected WizardModel buildModelSteps(SRARouteTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject));
        wizardModel.add((IWizardStep)new Predicates(modelObject));
        wizardModel.add((IWizardStep)new Filters(modelObject));
        return wizardModel;
    }

    private static class Filters
    extends WizardStep {
        private static final long serialVersionUID = -6552124285142294023L;

        Filters(SRARouteTO route) {
            super((IModel)new ResourceModel("filters"), (IModel)Model.of());
            this.add(new Component[]{new SRARouteFilterPanel("filters", (IModel<List<SRARouteFilter>>)new ListModel(route.getFilters()))});
        }
    }

    private static class Predicates
    extends WizardStep {
        private static final long serialVersionUID = 5934389493874714599L;

        Predicates(SRARouteTO route) {
            super((IModel)new ResourceModel("predicates"), (IModel)Model.of());
            this.add(new Component[]{new SRARoutePredicatePanel("predicates", (IModel<List<SRARoutePredicate>>)new ListModel(route.getPredicates()))});
        }
    }

    public static class Profile
    extends WizardStep {
        private static final long serialVersionUID = 8610155719550948702L;

        public Profile(final SRARouteTO route) {
            this.add(new Component[]{new AjaxTextFieldPanel("name", "name", (IModel)new PropertyModel((Object)route, "name"), false).addRequiredLabel().setEnabled(true)});
            AjaxTextFieldPanel target = new AjaxTextFieldPanel("target", "target", (IModel)new IModel<String>(){
                private static final long serialVersionUID = 1015030402166681242L;

                public String getObject() {
                    return Optional.ofNullable(route.getTarget()).map(URI::toASCIIString).orElse(null);
                }

                public void setObject(String object) {
                    route.setTarget((URI)Optional.ofNullable(object).map(URI::create).orElse(null));
                }
            }, false);
            target.addRequiredLabel().setEnabled(true);
            target.getField().add((IValidator)new UrlValidator(new String[]{"http", "https"}));
            this.add(new Component[]{target});
            AjaxTextFieldPanel error = new AjaxTextFieldPanel("error", "error", (IModel)new IModel<String>(){
                private static final long serialVersionUID = 1015030402166681242L;

                public String getObject() {
                    return route.getError() == null ? null : route.getError().toASCIIString();
                }

                public void setObject(String object) {
                    if (object == null) {
                        route.setError(null);
                    } else {
                        route.setError(URI.create(object));
                    }
                }
            }, false);
            error.getField().add((IValidator)new UrlValidator(new String[]{"http", "https"}));
            this.add(new Component[]{error});
            AjaxDropDownChoicePanel type = new AjaxDropDownChoicePanel("type", "type", (IModel)new PropertyModel((Object)route, "type"));
            type.setChoices(List.of(SRARouteType.values()));
            type.addRequiredLabel().setEnabled(true);
            this.add(new Component[]{type});
            this.add(new Component[]{new AjaxCheckBoxPanel("logout", "logout", (IModel)new PropertyModel((Object)route, "logout"))});
            AjaxTextFieldPanel postLogout = new AjaxTextFieldPanel("postLogout", "postLogout", (IModel)new IModel<String>(){
                private static final long serialVersionUID = 1015030402166681242L;

                public String getObject() {
                    return route.getPostLogout() == null ? null : route.getPostLogout().toASCIIString();
                }

                public void setObject(String object) {
                    if (object == null) {
                        route.setPostLogout(null);
                    } else {
                        route.setPostLogout(URI.create(object));
                    }
                }
            }, false);
            postLogout.getField().add((IValidator)new UrlValidator(new String[]{"http", "https"}));
            this.add(new Component[]{postLogout});
            this.add(new Component[]{new AjaxCheckBoxPanel("csrf", "csrf", (IModel)new PropertyModel((Object)route, "csrf"))});
            this.add(new Component[]{new AjaxSpinnerFieldPanel.Builder().min((Number)0).build("order", "order", Integer.class, (IModel)new PropertyModel((Object)route, "order")).setRequired(true)});
        }
    }
}

