/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.authprofiles;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.authprofiles.AuthProfileWizardBuilder;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.AuthProfileRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.ModalPanelBuilder;
import org.apache.syncope.common.lib.BaseBean;
import org.apache.syncope.common.lib.to.AuthProfileTO;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthAccount;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public abstract class AuthProfileItemDirectoryPanel<I extends BaseBean>
extends DirectoryPanel<I, I, AuthProfileItemProvider, AuthProfileRestClient> {
    private static final long serialVersionUID = 1L;
    private final BaseModal<AuthProfileTO> authProfileModal;
    private final AuthProfileTO authProfile;

    public AuthProfileItemDirectoryPanel(String id, BaseModal<AuthProfileTO> authProfileModal, AuthProfileTO authProfile, PageReference pageRef) {
        super(id, pageRef, false);
        this.authProfileModal = authProfileModal;
        this.authProfile = authProfile;
        this.setOutputMarkupId(true);
        this.enableUtilityButton();
        this.setFooterVisibility(false);
        this.addNewItemPanelBuilder((ModalPanelBuilder)new AuthProfileItemWizardBuilder(pageRef), true);
        this.disableCheckBoxes();
        this.initResultTable();
    }

    protected abstract List<I> getItems();

    protected abstract I defaultItem();

    protected abstract String sortProperty();

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof WizardMgtPanel.ExitEvent) {
            AjaxRequestTarget target = ((WizardMgtPanel.ExitEvent)WizardMgtPanel.ExitEvent.class.cast(event.getPayload())).getTarget();
            this.authProfileModal.close((IPartialPageRequestHandler)target);
        } else if (event.getPayload() instanceof AjaxWizard.EditItemActionEvent) {
            AjaxWizard.EditItemActionEvent payload = (AjaxWizard.EditItemActionEvent)event.getPayload();
            payload.getTarget().ifPresent(arg_0 -> ((ActionLinksTogglePanel)this.actionTogglePanel).close(arg_0));
        }
        super.onEvent(event);
    }

    protected AuthProfileItemProvider dataProvider() {
        return new AuthProfileItemProvider(this.sortProperty(), this.rows);
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    public ActionsPanel<I> getActions(final IModel<I> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add(new ActionLink<I>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, I ignore) {
                AuthProfileItemDirectoryPanel.this.send((IEventSink)AuthProfileItemDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((BaseBean)model.getObject()), target));
            }
        }, ActionLink.ActionType.EDIT, "AUTH_PROFILE_UPDATE");
        panel.add(new ActionLink<I>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, I ignore) {
                try {
                    AuthProfileItemDirectoryPanel.this.getItems().remove(model.getObject());
                    AuthProfileRestClient.update(AuthProfileItemDirectoryPanel.this.authProfile);
                    SyncopeConsoleSession.get().success((Serializable)((Object)AuthProfileItemDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{AuthProfileItemDirectoryPanel.this.container});
                }
                catch (Exception e) {
                    LOG.error("While deleting {} from {}", new Object[]{model.getObject(), AuthProfileItemDirectoryPanel.this.authProfile.getKey(), e});
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BaseWebPage)AuthProfileItemDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "AUTH_PROFILE_UPDATE", true);
        return panel;
    }

    private class AuthProfileItemWizardBuilder
    extends AuthProfileWizardBuilder<I> {
        private static final long serialVersionUID = 1L;

        AuthProfileItemWizardBuilder(PageReference pageRef) {
            super(AuthProfileItemDirectoryPanel.this.defaultItem(), new AuthProfileWizardBuilder.StepModel(), pageRef);
        }

        protected Serializable onApplyInternal(I modelObject) {
            BeanWrapper wrapper;
            List values;
            if (modelObject instanceof GoogleMfaAuthAccount && (values = (List)(wrapper = PropertyAccessorFactory.forBeanPropertyAccess(modelObject)).getPropertyValue("scratchCodes")) != null) {
                List converted = values.stream().map(value -> {
                    if (value instanceof Integer) {
                        return (Integer)Integer.class.cast(value);
                    }
                    if (value instanceof String) {
                        try {
                            return Integer.valueOf((String)((Object)value));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to Integer: {}", value, (Object)e);
                        }
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                wrapper.setPropertyValue("scratchCodes", converted);
            }
            AuthProfileItemDirectoryPanel.this.getItems().remove(this.model.getInitialModelObject());
            AuthProfileItemDirectoryPanel.this.getItems().add(modelObject);
            AuthProfileRestClient.update(AuthProfileItemDirectoryPanel.this.authProfile);
            return modelObject;
        }
    }

    protected class AuthProfileItemProvider
    extends DirectoryDataProvider<I> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final SortableDataProviderComparator<I> comparator;

        AuthProfileItemProvider(String sort, int paginatorRows) {
            super(paginatorRows);
            this.setSort(sort, SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator((SortableDataProvider)this);
        }

        public Iterator<I> iterator(long first, long count) {
            List list = AuthProfileItemDirectoryPanel.this.getItems();
            list.sort(this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return AuthProfileItemDirectoryPanel.this.getItems().size();
        }

        public IModel<I> model(I object) {
            return new CompoundPropertyModel(object);
        }
    }
}

