/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.pipe;

import java.io.IOException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.axis2.transport.base.datagram.AbstractDatagramTransportListener;
import org.apache.axis2.transport.base.datagram.DatagramDispatcherCallback;
import org.apache.synapse.transport.pipe.PipeDispatcher;
import org.apache.synapse.transport.pipe.PipeEndpoint;
import org.apache.synapse.transport.pipe.Protocol;

public class PipeListener
extends AbstractDatagramTransportListener<PipeEndpoint>
implements ManagementSupport {
    private Protocol protocol;

    protected void doInit() throws AxisFault {
        Protocol protocol;
        Class<Protocol> protocolClass;
        TransportInDescription transportIn = this.getTransportInDescription();
        String protocolClassName = ParamUtils.getRequiredParam((ParameterInclude)transportIn, (String)"protocol");
        try {
            protocolClass = Thread.currentThread().getContextClassLoader().loadClass(protocolClassName).asSubclass(Protocol.class);
        }
        catch (ClassNotFoundException ex) {
            throw new AxisFault("Unable to load the protocol implementation '" + protocolClassName + "'");
        }
        catch (ClassCastException ex) {
            throw new AxisFault("The protocol implementation " + protocolClassName + " doesn't extend " + Protocol.class.getName());
        }
        try {
            protocol = protocolClass.newInstance();
        }
        catch (Exception ex) {
            throw new AxisFault("Couldn't instantiate " + protocolClassName);
        }
        protocol.init((ParameterInclude)transportIn);
        this.protocol = protocol;
    }

    protected PipeDispatcher createDispatcher(DatagramDispatcherCallback callback) throws IOException {
        return new PipeDispatcher(callback);
    }

    protected PipeEndpoint doCreateEndpoint() {
        PipeEndpoint endpoint = new PipeEndpoint();
        endpoint.setProtocol(this.protocol);
        return endpoint;
    }
}

