/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.pipe;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.CountDownLatch;
import org.apache.axis2.transport.base.datagram.DatagramDispatcherCallback;
import org.apache.axis2.transport.base.datagram.DatagramEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.pipe.PipeEndpoint;
import org.apache.synapse.transport.pipe.ProtocolDecoder;

public class PipeEndpointListener
implements Runnable {
    private static final Log log = LogFactory.getLog(PipeEndpointListener.class);
    private final PipeEndpoint endpoint;
    private final DatagramDispatcherCallback callback;
    private final RandomAccessFile pipe;
    private final FileChannel readChannel;
    private final FileChannel writeChannel;
    private final Object guard = new Object();
    private boolean running;
    private final CountDownLatch done = new CountDownLatch(1);

    public PipeEndpointListener(PipeEndpoint endpoint, DatagramDispatcherCallback callback) throws IOException {
        this.endpoint = endpoint;
        this.callback = callback;
        this.pipe = new RandomAccessFile(endpoint.getPipe(), "rw");
        FileDescriptor fd = this.pipe.getFD();
        this.readChannel = new FileInputStream(fd).getChannel();
        this.writeChannel = new FileOutputStream(fd).getChannel();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Pipe " + endpoint.getPipe().getAbsolutePath() + " opened"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.running = true;
        ByteBuffer readBuffer = ByteBuffer.allocate(1024);
        try {
            ProtocolDecoder decoder = this.endpoint.getProtocol().createProtocolDecoder();
            while (true) {
                if (decoder.inputRequired()) {
                    int c;
                    try {
                        c = this.readChannel.read(readBuffer);
                    }
                    catch (IOException ex) {
                        log.error((Object)("Error while reading from pipe " + this.endpoint.getPipe().getAbsolutePath() + "; shutting down listener"), (Throwable)ex);
                        try {
                            this.pipe.close();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Pipe " + this.endpoint.getPipe().getAbsolutePath() + " closed"));
                            }
                        }
                        catch (IOException ex2) {
                            log.warn((Object)("Error while closing pipe " + this.endpoint.getPipe().getAbsolutePath()), (Throwable)ex2);
                        }
                        this.done.countDown();
                        return;
                    }
                    if (c == -1) {
                        log.error((Object)("Pipe " + this.endpoint.getPipe().getAbsolutePath() + " was unexpectedly closed; shutting down listener"));
                        return;
                    }
                    Object object = this.guard;
                    synchronized (object) {
                        if (!this.running) {
                            return;
                        }
                    }
                    decoder.decode(readBuffer.array(), 0, readBuffer.position());
                    readBuffer.rewind();
                    continue;
                }
                byte[] message = decoder.getNext();
                this.callback.receive((DatagramEndpoint)this.endpoint, message, message.length, null);
            }
        }
        finally {
            try {
                this.pipe.close();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Pipe " + this.endpoint.getPipe().getAbsolutePath() + " closed"));
                }
            }
            catch (IOException ex) {
                log.warn((Object)("Error while closing pipe " + this.endpoint.getPipe().getAbsolutePath()), (Throwable)ex);
            }
            this.done.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopping listener for pipe " + this.endpoint.getPipe().getAbsolutePath() + " ..."));
        }
        Object object = this.guard;
        synchronized (object) {
            this.running = false;
            this.writeChannel.write(ByteBuffer.allocate(1));
        }
        try {
            this.done.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listener for pipe " + this.endpoint.getPipe().getAbsolutePath() + " stopped"));
        }
    }
}

