/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.pipe;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.axis2.transport.base.datagram.DatagramDispatcher;
import org.apache.axis2.transport.base.datagram.DatagramDispatcherCallback;
import org.apache.synapse.transport.pipe.PipeEndpoint;
import org.apache.synapse.transport.pipe.PipeEndpointListener;

public class PipeDispatcher
implements DatagramDispatcher<PipeEndpoint> {
    private final DatagramDispatcherCallback callback;
    private final Map<PipeEndpoint, PipeEndpointListener> endpointListeners = new IdentityHashMap<PipeEndpoint, PipeEndpointListener>();

    public PipeDispatcher(DatagramDispatcherCallback callback) {
        this.callback = callback;
    }

    public void addEndpoint(PipeEndpoint endpoint) throws IOException {
        File pipe = endpoint.getPipe();
        if (!pipe.exists()) {
            throw new FileNotFoundException(pipe.getAbsolutePath() + " not found");
        }
        if (pipe.isDirectory() || pipe.isFile()) {
            throw new IOException(pipe.getAbsolutePath() + " is not a pipe");
        }
        PipeEndpointListener listener = new PipeEndpointListener(endpoint, this.callback);
        new Thread((Runnable)listener, "pipe:" + pipe.getAbsolutePath()).start();
        this.endpointListeners.put(endpoint, listener);
    }

    public void removeEndpoint(PipeEndpoint endpoint) throws IOException {
        this.endpointListeners.get((Object)endpoint).stop();
        this.endpointListeners.remove((Object)endpoint);
    }

    public void stop() throws IOException {
        while (!this.endpointListeners.isEmpty()) {
            this.removeEndpoint(this.endpointListeners.keySet().iterator().next());
        }
    }
}

