/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.pipe;

import java.io.ByteArrayOutputStream;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.synapse.transport.pipe.Protocol;
import org.apache.synapse.transport.pipe.ProtocolDecoder;

public class EndDelimitedProtocol
implements Protocol {
    private byte delimiter;

    @Override
    public void init(ParameterInclude paramInclude) throws AxisFault {
        this.delimiter = (byte)ParamUtils.getRequiredParamInt((ParameterInclude)paramInclude, (String)"delimiter");
    }

    public byte getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(byte delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public ProtocolDecoder createProtocolDecoder() {
        return new ProtocolDecoderImpl();
    }

    private class ProtocolDecoderImpl
    implements ProtocolDecoder {
        private final ByteArrayOutputStream messageBuffer = new ByteArrayOutputStream();
        private final Queue<byte[]> messages = new LinkedList<byte[]>();

        @Override
        public boolean inputRequired() {
            return this.messages.isEmpty();
        }

        @Override
        public void decode(byte[] buf, int offset, int length) {
            byte delimiter = EndDelimitedProtocol.this.getDelimiter();
            int start = offset;
            for (int i = offset; i < length; ++i) {
                if (buf[i] != delimiter) continue;
                this.messageBuffer.write(buf, start, i - start);
                start = i + 1;
                this.messages.add(this.messageBuffer.toByteArray());
                this.messageBuffer.reset();
            }
            this.messageBuffer.write(buf, start, length - start);
        }

        @Override
        public byte[] getNext() {
            return this.messages.poll();
        }
    }
}

