/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.k8s.utils;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class K8sUtils {
    private static final Logger LOG = LoggerFactory.getLogger(K8sUtils.class);
    private static String namespace = null;
    public static final DateTimeFormatter UTC_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssX");

    public static String getNamespace() {
        if (namespace == null) {
            namespace = System.getenv("ENV_NAMESPACE");
            if (namespace == null) {
                namespace = "default";
            }
            LOG.info("Namespace: {}", (Object)namespace);
        }
        return namespace;
    }

    public static String castOffsetDatetimeToString(OffsetDateTime odt) {
        if (odt == null) {
            return null;
        }
        return UTC_DATE_FORMATTER.format(odt.withOffsetSameInstant(ZoneOffset.UTC));
    }
}

