/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.plexus;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts2.plexus.PlexusObjectFactory;
import org.apache.struts2.plexus.PlexusThreadLocal;
import org.apache.struts2.plexus.PlexusUtils;
import org.codehaus.plexus.PlexusContainer;

public class PlexusFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(PlexusObjectFactory.class);
    private static final String CHILD_CONTAINER_NAME = "request";
    private static boolean loaded = false;
    private ServletContext ctx;

    public static boolean isLoaded() {
        return loaded;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.ctx = filterConfig.getServletContext();
        loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        PlexusContainer child = null;
        try {
            try {
                HttpServletRequest request = (HttpServletRequest)req;
                HttpSession session = request.getSession(false);
                PlexusContainer parent = session != null ? (PlexusContainer)session.getAttribute("struts.plexus.container") : (PlexusContainer)this.ctx.getAttribute("struts.plexus.container");
                if (parent.hasChildContainer(CHILD_CONTAINER_NAME)) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Plexus container (scope: request) alredy exist.", new String[0]);
                    }
                    child = parent.getChildContainer(CHILD_CONTAINER_NAME);
                } else {
                    child = parent.createChildContainer(CHILD_CONTAINER_NAME, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
                    PlexusUtils.configure(child, "plexus-request.xml");
                    child.initialize();
                    child.start();
                }
                PlexusThreadLocal.setPlexusContainer(child);
            }
            catch (Exception e) {
                LOG.error("Error initializing plexus container (scope: request)", (Throwable)e, new String[0]);
            }
            chain.doFilter(req, res);
        }
        finally {
            try {
                if (child != null) {
                    child.dispose();
                }
                PlexusThreadLocal.setPlexusContainer(null);
            }
            catch (Exception e) {
                LOG.error("Error disposing plexus container (scope: request)", (Throwable)e, new String[0]);
            }
        }
    }

    public void destroy() {
    }
}

