/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.plexus;

import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.InterceptorConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.Interceptor;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.validator.Validator;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.struts2.plexus.PlexusFilter;
import org.apache.struts2.plexus.PlexusLifecycleListener;
import org.apache.struts2.plexus.PlexusThreadLocal;
import org.codehaus.plexus.PlexusContainer;

public class PlexusObjectFactory
extends ObjectFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PlexusObjectFactory.class);
    private static final String PLEXUS_COMPONENT_TYPE = "plexus.component.type";
    private PlexusContainer base;

    @Inject
    public void setServletConfig(ServletContext servletContext) {
        if (!PlexusLifecycleListener.isLoaded() || !PlexusFilter.isLoaded()) {
            String message = "********** FATAL ERROR STARTING UP PLEXUS-STRUTS INTEGRATION **********\nLooks like the Plexus listener was not configured for your web app! \nYou need to add the following to web.xml: \n\n    <!-- this should be before the Struts filter -->\n    <filter>\n        <filter-name>plexus</filter-name>\n        <filter-class>org.apache.struts2.plexus.PlexusFilter</filter-class>\n    </filter>\n\n...\n\n    <!-- this should be before the Struts filter -->\n    <filter-mapping>\n        <filter-name>plexus</filter-name>\n        <url-pattern>/*</url-pattern>\n    </filter-mapping>\n\n...\n\n    <listener>\n        <listener-class>org.apache.struts2.plexus.PlexusLifecycleListener</listener-class>\n    </listener>";
            LOG.fatal(message, new String[0]);
            return;
        }
        this.base = (PlexusContainer)servletContext.getAttribute("struts.plexus.container");
    }

    public Object buildAction(String actionName, String namespace, ActionConfig config, Map extraContext) throws Exception {
        if (extraContext == null) {
            extraContext = new HashMap<String, String>();
        }
        extraContext.put(PLEXUS_COMPONENT_TYPE, Action.class.getName());
        return super.buildAction(actionName, namespace, config, extraContext);
    }

    public Interceptor buildInterceptor(InterceptorConfig interceptorConfig, Map interceptorRefParams) throws ConfigurationException {
        String message;
        Throwable cause;
        String interceptorClassName = interceptorConfig.getClassName();
        Map thisInterceptorClassParams = interceptorConfig.getParams();
        HashMap params = thisInterceptorClassParams == null ? new HashMap() : new HashMap(thisInterceptorClassParams);
        params.putAll(interceptorRefParams);
        try {
            HashMap<String, String> extraContext = new HashMap<String, String>();
            extraContext.put(PLEXUS_COMPONENT_TYPE, Interceptor.class.getName());
            Interceptor interceptor = (Interceptor)this.buildBean(interceptorClassName, extraContext);
            this.reflectionProvider.setProperties(params, (Object)interceptor);
            interceptor.init();
            return interceptor;
        }
        catch (InstantiationException e) {
            cause = e;
            message = "Unable to instantiate an instance of Interceptor class [" + interceptorClassName + "].";
        }
        catch (IllegalAccessException e) {
            cause = e;
            message = "IllegalAccessException while attempting to instantiate an instance of Interceptor class [" + interceptorClassName + "].";
        }
        catch (ClassCastException e) {
            cause = e;
            message = "Class [" + interceptorClassName + "] does not implement com.opensymphony.xwork2.interceptor.Interceptor";
        }
        catch (Exception e) {
            cause = e;
            message = "Caught Exception while registering Interceptor class " + interceptorClassName;
        }
        catch (NoClassDefFoundError e) {
            cause = e;
            message = "Could not load class " + interceptorClassName + ". Perhaps it exists but certain dependencies are not available?";
        }
        throw new ConfigurationException(message, cause);
    }

    public Result buildResult(ResultConfig resultConfig, Map extraContext) throws Exception {
        if (extraContext == null) {
            extraContext = new HashMap<String, String>();
        }
        extraContext.put(PLEXUS_COMPONENT_TYPE, Result.class.getName());
        return super.buildResult(resultConfig, extraContext);
    }

    public Validator buildValidator(String className, Map params, Map extraContext) throws Exception {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(PLEXUS_COMPONENT_TYPE, Validator.class.getName());
        Validator validator = (Validator)this.buildBean(className, context);
        this.reflectionProvider.setProperties(params, (Object)validator);
        return validator;
    }

    public Object buildBean(Class clazz, Map extraContext) throws Exception {
        try {
            return this.lookup(clazz.getName(), extraContext);
        }
        catch (Exception e) {
            String type;
            if (extraContext != null && (type = (String)extraContext.get(PLEXUS_COMPONENT_TYPE)) != null) {
                return this.lookup(type, clazz.getName(), extraContext);
            }
            throw e;
        }
    }

    public Class getClassInstance(String className) throws ClassNotFoundException {
        PlexusContainer pc = PlexusThreadLocal.getPlexusContainer();
        if (pc == null) {
            pc = this.base;
        }
        try {
            return pc.lookup(className).getClass();
        }
        catch (Exception e1) {
            try {
                return pc.lookup(Action.class.getName(), className).getClass();
            }
            catch (Exception e2) {
                try {
                    return pc.lookup(Interceptor.class.getName(), className).getClass();
                }
                catch (Exception e3) {
                    try {
                        return pc.lookup(Validator.class.getName(), className).getClass();
                    }
                    catch (Exception e4) {
                        try {
                            return pc.lookup(Result.class.getName(), className).getClass();
                        }
                        catch (Exception e5) {
                            return super.getClassInstance(className);
                        }
                    }
                }
            }
        }
    }

    private Object lookup(String role, Map extraContext) throws Exception {
        return this.lookup(role, null, extraContext);
    }

    private Object lookup(String role, String roleHint, Map extraContext) throws Exception {
        PlexusContainer pc = PlexusThreadLocal.getPlexusContainer();
        if (pc == null) {
            pc = this.base;
        }
        try {
            return pc.lookup(role, roleHint);
        }
        catch (Exception e) {
            LOG.debug("Can't load component (" + role + "/" + roleHint + ") with plexus, try now with struts.", (Throwable)e, new String[0]);
            Object o = super.buildBean(super.getClassInstance(role), extraContext);
            pc.autowire(o);
            return o;
        }
    }
}

