/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.multipart;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import http.utils.multipartrequest.MultipartRequest;
import http.utils.multipartrequest.ServletMultipartRequest;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;

public class PellMultiPartRequest
implements MultiPartRequest {
    private static final Logger LOG = LoggerFactory.getLogger(PellMultiPartRequest.class);
    private ServletMultipartRequest multi;
    private String defaultEncoding;
    private boolean maxSizeProvided;
    private int maxSize;

    @Inject(value="struts.i18n.encoding")
    public void setDefaultEncoding(String enc) {
        this.defaultEncoding = enc;
    }

    @Inject(value="struts.multipart.maxSize")
    public void setMaxSize(String maxSize) {
        this.maxSizeProvided = true;
        this.maxSize = Integer.parseInt(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(HttpServletRequest servletRequest, String saveDir) throws IOException {
        PellMultiPartRequest pellMultiPartRequest = this;
        synchronized (pellMultiPartRequest) {
            this.setEncoding();
            this.multi = this.maxSizeProvided ? new ServletMultipartRequest(servletRequest, saveDir, this.maxSize) : new ServletMultipartRequest(servletRequest, saveDir);
        }
    }

    public Enumeration getFileParameterNames() {
        return this.multi.getFileParameterNames();
    }

    public String[] getContentType(String fieldName) {
        return new String[]{this.multi.getContentType(fieldName)};
    }

    public File[] getFile(String fieldName) {
        return new File[]{this.multi.getFile(fieldName)};
    }

    public String[] getFileNames(String fieldName) {
        return new String[]{this.multi.getFile(fieldName).getName()};
    }

    public String[] getFilesystemName(String fieldName) {
        return new String[]{this.multi.getFileSystemName(fieldName)};
    }

    public String getParameter(String name) {
        return this.multi.getURLParameter(name);
    }

    public Enumeration getParameterNames() {
        return this.multi.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        Enumeration enumeration = this.multi.getURLParameters(name);
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        ArrayList values = new ArrayList();
        while (enumeration.hasMoreElements()) {
            values.add(enumeration.nextElement());
        }
        return values.toArray(new String[values.size()]);
    }

    public List getErrors() {
        return Collections.EMPTY_LIST;
    }

    private void setEncoding() {
        String encoding = null;
        try {
            encoding = this.defaultEncoding;
            if (encoding != null) {
                MultipartRequest.setEncoding((String)encoding);
            } else {
                MultipartRequest.setEncoding((String)"UTF-8");
            }
        }
        catch (IllegalArgumentException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Could not get encoding property 'struts.i18n.encoding' for file upload.  Using system default", new String[0]);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Encoding " + encoding + " is not a valid encoding.  Please check your struts.properties file.", new String[0]);
        }
    }
}

