/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.XWorkTestCase;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.logging.jdk.JdkLoggerFactory;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.util.StrutsTestCaseHelper;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.mock.web.MockPageContext;
import org.springframework.mock.web.MockServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StrutsTestCase
extends XWorkTestCase {
    protected MockHttpServletResponse response;
    protected MockHttpServletRequest request;
    protected MockPageContext pageContext;
    protected MockServletContext servletContext;
    protected Map<String, String> dispatcherInitParams;
    protected Dispatcher dispatcher;
    protected DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
    private static final com.opensymphony.xwork2.util.logging.Logger LOG;

    protected Object findValueAfterExecute(String key) {
        return ServletActionContext.getValueStack((HttpServletRequest)this.request).findValue(key);
    }

    protected String executeAction(String uri) throws ServletException, UnsupportedEncodingException {
        this.request.setRequestURI(uri);
        ActionMapping mapping = this.getActionMapping((HttpServletRequest)this.request);
        StrutsTestCase.assertNotNull((Object)mapping);
        Dispatcher.getInstance().serviceAction((HttpServletRequest)this.request, (HttpServletResponse)this.response, mapping);
        if (this.response.getStatus() != 200) {
            throw new ServletException("Error code [" + this.response.getStatus() + "], Error: [" + this.response.getErrorMessage() + "]");
        }
        return this.response.getContentAsString();
    }

    protected ActionProxy getActionProxy(String uri) {
        this.request.setRequestURI(uri);
        ActionMapping mapping = this.getActionMapping((HttpServletRequest)this.request);
        String namespace = mapping.getNamespace();
        String name = mapping.getName();
        String method = mapping.getMethod();
        Configuration config = this.configurationManager.getConfiguration();
        ActionProxy proxy = ((ActionProxyFactory)config.getContainer().getInstance(ActionProxyFactory.class)).createActionProxy(namespace, name, method, new HashMap(), true, false);
        this.initActionContext(proxy.getInvocation().getInvocationContext());
        ServletActionContext.setServletContext((ServletContext)this.servletContext);
        ServletActionContext.setRequest((HttpServletRequest)this.request);
        ServletActionContext.setResponse((HttpServletResponse)this.response);
        return proxy;
    }

    protected void initActionContext(ActionContext actionContext) {
        actionContext.setParameters(new HashMap(this.request.getParameterMap()));
        this.initSession(actionContext);
        this.applyAdditionalParams(actionContext);
        ActionContext.setContext((ActionContext)actionContext);
    }

    protected void initSession(ActionContext actionContext) {
        if (actionContext.getSession() == null) {
            actionContext.setSession(new HashMap());
            this.request.setSession((HttpSession)new MockHttpSession((ServletContext)this.servletContext));
        }
    }

    protected void applyAdditionalParams(ActionContext context) {
    }

    protected ActionMapping getActionMapping(HttpServletRequest request) {
        return ((ActionMapper)this.container.getInstance(ActionMapper.class)).getMapping(request, this.configurationManager);
    }

    protected ActionMapping getActionMapping(String url) {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI(url);
        return this.getActionMapping((HttpServletRequest)req);
    }

    protected void injectStrutsDependencies(Object object) {
        this.container.inject(object);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.initServletMockObjects();
        this.setupBeforeInitDispatcher();
        this.dispatcher = this.initDispatcher(this.dispatcherInitParams);
        this.setupAfterInitDispatcher(this.dispatcher);
    }

    protected void setupBeforeInitDispatcher() throws Exception {
    }

    protected void setupAfterInitDispatcher(Dispatcher dispatcher) {
    }

    protected void initServletMockObjects() {
        this.servletContext = new MockServletContext((ResourceLoader)this.resourceLoader);
        this.response = new MockHttpServletResponse();
        this.request = new MockHttpServletRequest();
        this.pageContext = new MockPageContext((ServletContext)this.servletContext, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
    }

    protected Dispatcher initDispatcher(Map<String, String> params) {
        Dispatcher du = StrutsTestCaseHelper.initDispatcher((ServletContext)this.servletContext, params);
        this.configurationManager = du.getConfigurationManager();
        this.configuration = this.configurationManager.getConfiguration();
        this.container = this.configuration.getContainer();
        return du;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.dispatcher != null && this.dispatcher.getConfigurationManager() != null) {
            this.dispatcher.cleanup();
            this.dispatcher = null;
        }
        StrutsTestCaseHelper.tearDown();
    }

    static {
        ConsoleHandler handler = new ConsoleHandler();
        final SimpleDateFormat df = new SimpleDateFormat("mm:ss.SSS");
        Formatter formatter = new Formatter(){

            public String format(LogRecord record) {
                StringBuilder sb = new StringBuilder();
                sb.append(record.getLevel());
                sb.append(':');
                for (int x = 9 - record.getLevel().toString().length(); x > 0; --x) {
                    sb.append(' ');
                }
                sb.append('[');
                sb.append(df.format(new Date(record.getMillis())));
                sb.append("] ");
                sb.append(this.formatMessage(record));
                sb.append('\n');
                return sb.toString();
            }
        };
        handler.setFormatter(formatter);
        Logger logger = Logger.getLogger("");
        if (logger.getHandlers().length > 0) {
            logger.removeHandler(logger.getHandlers()[0]);
        }
        logger.addHandler(handler);
        logger.setLevel(Level.WARNING);
        LoggerFactory.setLoggerFactory((LoggerFactory)new JdkLoggerFactory());
        LOG = LoggerFactory.getLogger(StrutsTestCase.class);
    }
}

