/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.compiler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.struts2.compiler.MemoryJavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryClassLoader
extends ClassLoader {
    private Map<String, MemoryJavaFileObject> cachedObjects = new ConcurrentHashMap<String, MemoryJavaFileObject>();

    public MemoryClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        MemoryJavaFileObject fileObject = this.cachedObjects.get(name);
        if (fileObject != null) {
            byte[] bytes = fileObject.toByteArray();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        return super.findClass(name);
    }

    public void addMemoryJavaFileObject(String jsp, MemoryJavaFileObject memoryJavaFileObject) {
        this.cachedObjects.put(jsp, memoryJavaFileObject);
    }
}

