/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2;

import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterface;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterfaceDelegate;
import com.opensymphony.xwork2.util.finder.UrlSet;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspPage;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.EmbeddedJSPResult;
import org.apache.struts2.JSPServletConfig;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.StrutsException;
import org.apache.struts2.compiler.MemoryClassLoader;
import org.apache.struts2.compiler.MemoryJavaFileObject;
import org.apache.struts2.jasper.JasperException;
import org.apache.struts2.jasper.JspC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSPLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JSPLoader.class);
    private static MemoryClassLoader classLoader = new MemoryClassLoader();
    private static final String DEFAULT_PACKAGE = "org.apache.struts2.jsp";
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package (.*?);");
    private static final Pattern CLASS_PATTERN = Pattern.compile("public final class (.*?) ");

    public Servlet load(String location) throws Exception {
        location = StringUtils.substringBeforeLast((String)location, (String)"?");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Compiling JSP [#0]", new String[]{location});
        }
        JspC jspC = this.compileJSP(location);
        String source = jspC.getSourceCode();
        String className = this.extractClassName(source);
        this.compileJava(className, source, jspC.getTldAbsolutePaths());
        Class<?> clazz = Class.forName(className, false, classLoader);
        return this.createServlet(clazz);
    }

    private String extractClassName(String source) {
        Matcher matcher = PACKAGE_PATTERN.matcher(source);
        matcher.find();
        String packageName = matcher.group(1);
        matcher = CLASS_PATTERN.matcher(source);
        matcher.find();
        String className = matcher.group(1);
        return packageName + "." + className;
    }

    private Servlet createServlet(Class clazz) throws IllegalAccessException, InstantiationException, ServletException {
        JSPServletConfig config = new JSPServletConfig(ServletActionContext.getServletContext());
        Servlet servlet = (Servlet)clazz.newInstance();
        servlet.init((ServletConfig)config);
        return servlet;
    }

    private void compileJava(String className, final String source, Set<String> extraClassPath) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Compiling [#0], source: [#1]", new String[]{className, source});
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ForwardingJavaFileManager<StandardJavaFileManager> jfm = new ForwardingJavaFileManager<StandardJavaFileManager>(compiler.getStandardFileManager(diagnostics, null, null)){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                MemoryJavaFileObject fileObject = new MemoryJavaFileObject(name, kind);
                classLoader.addMemoryJavaFileObject(name, fileObject);
                return fileObject;
            }
        };
        String fileName = className.replace('.', '/') + ".java";
        SimpleJavaFileObject sourceCodeObject = new SimpleJavaFileObject(JSPLoader.toURI(fileName), JavaFileObject.Kind.SOURCE){

            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException, IllegalStateException, UnsupportedOperationException {
                return source;
            }
        };
        ArrayList<String> optionList = new ArrayList<String>();
        HashSet<String> classPath = new HashSet<String>();
        FileManager fileManager = ((FileManagerFactory)ServletActionContext.getContext().getInstance(FileManagerFactory.class)).getFileManager();
        ClassLoaderInterface classLoaderInterface = this.getClassLoaderInterface();
        UrlSet urlSet = new UrlSet(classLoaderInterface);
        List urls = urlSet.getUrls();
        for (URL url : urls) {
            URL normalizedUrl = fileManager.normalizeToFileProtocol(url);
            File file = FileUtils.toFile((URL)((URL)ObjectUtils.defaultIfNull((Object)normalizedUrl, (Object)url)));
            if (!file.exists()) continue;
            classPath.add(file.getAbsolutePath());
        }
        classPath.add(this.getJarUrl(EmbeddedJSPResult.class));
        classPath.add(this.getJarUrl(Servlet.class));
        classPath.add(this.getJarUrl(JspPage.class));
        try {
            Class<?> annotationsProcessor = Class.forName("org.apache.AnnotationProcessor");
            classPath.add(this.getJarUrl(annotationsProcessor));
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        for (String entry : extraClassPath) {
            classPath.add(entry);
        }
        String classPathString = StringUtils.join(classPath, (String)File.pathSeparator);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Compiling [#0] with classpath [#1]", new String[]{className, classPathString});
        }
        optionList.addAll(Arrays.asList("-classpath", classPathString));
        JavaCompiler.CompilationTask task = compiler.getTask(null, jfm, diagnostics, optionList, null, Arrays.asList(sourceCodeObject));
        if (!task.call().booleanValue()) {
            throw new StrutsException("Compilation failed:" + diagnostics.getDiagnostics().get(0).toString());
        }
    }

    protected String getJarUrl(Class clazz) {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL loc = codeSource.getLocation();
        File file = FileUtils.toFile((URL)loc);
        return file.getAbsolutePath();
    }

    private JspC compileJSP(String location) throws JasperException {
        JspC jspC = new JspC();
        jspC.setClassLoaderInterface(this.getClassLoaderInterface());
        jspC.setCompile(false);
        jspC.setJspFiles(location);
        jspC.setPackage(DEFAULT_PACKAGE);
        jspC.execute();
        return jspC;
    }

    private ClassLoaderInterface getClassLoaderInterface() {
        ClassLoaderInterface classLoaderInterface = null;
        ServletContext ctx = ServletActionContext.getServletContext();
        if (ctx != null) {
            classLoaderInterface = (ClassLoaderInterface)ctx.getAttribute("__current_class_loader_interface");
        }
        return (ClassLoaderInterface)ObjectUtils.defaultIfNull((Object)classLoaderInterface, (Object)new ClassLoaderInterfaceDelegate(JSPLoader.class.getClassLoader()));
    }

    private static URI toURI(String name) {
        try {
            return new URI(name);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

