/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.beanvalidation.validation.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.util.AnnotationUtils;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validator;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.beanvalidation.validation.interceptor.BeanValidationManager;
import org.apache.struts2.interceptor.validation.SkipValidation;

public class BeanValidationInterceptor
extends MethodFilterInterceptor {
    private static final Logger LOG = LogManager.getLogger(BeanValidationInterceptor.class);
    protected BeanValidationManager beanValidationManager;
    protected boolean convertToUtf8 = false;
    protected String convertFromEncoding = "ISO-8859-1";

    @Inject
    public void setBeanValidationManager(BeanValidationManager beanValidationManager) {
        this.beanValidationManager = beanValidationManager;
    }

    @Inject(value="struts.beanValidation.convertMessageToUtf", required=false)
    public void setConvertToUtf8(String convertToUtf8) {
        this.convertToUtf8 = BooleanUtils.toBoolean((String)convertToUtf8);
    }

    @Inject(value="struts.beanValidation.convertMessageFromEncoding", required=false)
    public void setConvertFromEncoding(String convertFromEncoding) {
        this.convertFromEncoding = convertFromEncoding;
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        Collection annotatedMethods;
        Validator validator = this.beanValidationManager.getValidator();
        if (validator == null) {
            LOG.debug("There is no Bean Validator configured in class path. Skipping Bean validation..");
            return invocation.invoke();
        }
        LOG.debug("Starting bean validation using validator: {}", new Object[]{validator.getClass()});
        Object action = invocation.getAction();
        ActionProxy actionProxy = invocation.getProxy();
        String methodName = actionProxy.getMethod();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating [{}/{}] with method [{}]", new Object[]{invocation.getProxy().getNamespace(), invocation.getProxy().getActionName(), methodName});
        }
        if (!(annotatedMethods = AnnotationUtils.getAnnotatedMethods(action.getClass(), (Class[])new Class[]{SkipValidation.class})).contains(this.getActionMethod(action.getClass(), methodName))) {
            this.performBeanValidation(action, validator);
        }
        return invocation.invoke();
    }

    protected void performBeanValidation(Object action, Validator validator) {
        Set constraintViolations;
        LOG.trace("Initiating bean validation..");
        if (action instanceof ModelDriven) {
            LOG.trace("Performing validation on model..");
            Object model = ((ModelDriven)action).getModel();
            constraintViolations = validator.validate(model, new Class[0]);
        } else {
            LOG.trace("Performing validation on action..");
            constraintViolations = validator.validate(action, new Class[0]);
        }
        this.addBeanValidationErrors(constraintViolations, action);
    }

    private void addBeanValidationErrors(Set<ConstraintViolation<Object>> constraintViolations, Object action) {
        if (constraintViolations != null) {
            DelegatingValidatorContext validatorContext = new DelegatingValidatorContext(action);
            for (ConstraintViolation<Object> constraintViolation : constraintViolations) {
                String key;
                String message = key = constraintViolation.getMessage();
                try {
                    message = validatorContext.getText(key);
                    if (this.convertToUtf8 && StringUtils.isNotBlank((CharSequence)message)) {
                        message = new String(message.getBytes(this.convertFromEncoding), "UTF-8");
                    }
                }
                catch (Exception e) {
                    LOG.error("Error while trying to fetch message: {}", new Object[]{key, e});
                }
                if (this.isActionError(constraintViolation)) {
                    LOG.debug("Adding action error [{}]", new Object[]{message});
                    validatorContext.addActionError(message);
                    continue;
                }
                ValidationError validationError = this.buildBeanValidationError(constraintViolation, message);
                String fieldName = validationError.getFieldName();
                if (action instanceof ModelDriven && fieldName.startsWith("model")) {
                    fieldName = fieldName.replace("model.", "");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding field error [{}] with message [{}]", new Object[]{fieldName, validationError.getMessage()});
                }
                validatorContext.addFieldError(fieldName, validationError.getMessage());
            }
        }
    }

    protected ValidationError buildBeanValidationError(ConstraintViolation<Object> violation, String message) {
        if (((Path.Node)violation.getPropertyPath().iterator().next()).getName() != null) {
            String fieldName = violation.getPropertyPath().toString();
            String finalMessage = StringUtils.removeStart((String)message, (String)(fieldName + "."));
            return new ValidationError(fieldName, finalMessage);
        }
        return null;
    }

    protected boolean isActionError(ConstraintViolation<Object> violation) {
        return violation.getLeafBean() == violation.getInvalidValue();
    }

    protected Method getActionMethod(Class<?> actionClass, String methodName) throws NoSuchMethodException {
        Method method = actionClass.getMethod(methodName, new Class[0]);
        return method;
    }

    class ValidationError {
        private final String fieldName;
        private final String message;

        ValidationError(String fieldName, String message) {
            this.fieldName = fieldName;
            this.message = message;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

