/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.util;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.views.util.UrlHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUrlHelper
implements UrlHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUrlHelper.class);
    private String encoding = "UTF-8";

    @Inject(value="struts.i18n.encoding")
    public void setEncoding(String encoding) {
        if (StringUtils.isNotEmpty((CharSequence)encoding)) {
            this.encoding = encoding;
        }
    }

    @Override
    public String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) {
        return this.buildUrl(action, request, response, params, null, true, true);
    }

    @Override
    public String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map<String, Object> params, String scheme, boolean includeContext, boolean encodeResult) {
        return this.buildUrl(action, request, response, params, scheme, includeContext, encodeResult, false);
    }

    @Override
    public String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map<String, Object> params, String scheme, boolean includeContext, boolean encodeResult, boolean forceAddSchemeHostAndPort) {
        return this.buildUrl(action, request, response, params, scheme, includeContext, encodeResult, forceAddSchemeHostAndPort, true);
    }

    @Override
    public String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map<String, Object> params, String scheme, boolean includeContext, boolean encodeResult, boolean forceAddSchemeHostAndPort, boolean escapeAmp) {
        StringBuilder link = new StringBuilder();
        boolean changedScheme = false;
        Container cont = ActionContext.getContext().getContainer();
        int httpPort = Integer.parseInt((String)cont.getInstance(String.class, "struts.url.http.port"));
        int httpsPort = Integer.parseInt((String)cont.getInstance(String.class, "struts.url.https.port"));
        if (forceAddSchemeHostAndPort) {
            String reqScheme = request.getScheme();
            changedScheme = true;
            link.append(scheme != null ? scheme : reqScheme);
            link.append("://");
            link.append(request.getServerName());
            if (scheme != null) {
                if (!scheme.equals(reqScheme)) {
                    if (scheme.equals("http") && httpPort != 80 || scheme.equals("https") && httpsPort != 443) {
                        link.append(":");
                        link.append(scheme.equals("http") ? httpPort : httpsPort);
                    }
                } else {
                    int reqPort = request.getServerPort();
                    if (scheme.equals("http") && reqPort != 80 || scheme.equals("https") && reqPort != 443) {
                        link.append(":");
                        link.append(reqPort);
                    }
                }
            }
        } else if (scheme != null && !scheme.equals(request.getScheme())) {
            changedScheme = true;
            link.append(scheme);
            link.append("://");
            link.append(request.getServerName());
            if (scheme.equals("http") && httpPort != 80 || scheme.equals("https") && httpsPort != 443) {
                link.append(":");
                link.append(scheme.equals("http") ? httpPort : httpsPort);
            }
        }
        if (action != null) {
            if (action.startsWith("/") && includeContext) {
                String contextPath = request.getContextPath();
                if (!contextPath.equals("/")) {
                    link.append(contextPath);
                }
            } else if (changedScheme) {
                String uri = (String)request.getAttribute("javax.servlet.forward.request_uri");
                if (uri == null) {
                    uri = request.getRequestURI();
                }
                link.append(uri.substring(0, uri.lastIndexOf(47) + 1));
            }
            link.append(action);
        } else {
            String requestURI = (String)request.getAttribute("struts.request_uri");
            if (requestURI == null) {
                requestURI = (String)request.getAttribute("javax.servlet.forward.request_uri");
            }
            if (requestURI == null) {
                requestURI = request.getRequestURI();
            }
            link.append(requestURI);
        }
        if (escapeAmp) {
            this.buildParametersString(params, link, "&amp;");
        } else {
            this.buildParametersString(params, link, "&");
        }
        String result = link.toString();
        if (StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"<script")) {
            result = StringEscapeUtils.escapeEcmaScript((String)result);
        }
        try {
            result = encodeResult ? response.encodeURL(result) : result;
        }
        catch (Exception ex) {
            result = link.toString();
        }
        return result;
    }

    @Override
    public void buildParametersString(Map<String, Object> params, StringBuilder link, String paramSeparator) {
        if (params != null && params.size() > 0) {
            if (!link.toString().contains("?")) {
                link.append("?");
            } else {
                link.append(paramSeparator);
            }
            Iterator<Map.Entry<String, Object>> iter = params.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry = iter.next();
                String name = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Iterable) {
                    Iterator iterator = ((Iterable)value).iterator();
                    while (iterator.hasNext()) {
                        Object paramValue = iterator.next();
                        link.append(this.buildParameterSubstring(name, paramValue.toString()));
                        if (!iterator.hasNext()) continue;
                        link.append(paramSeparator);
                    }
                } else if (value instanceof Object[]) {
                    Object[] array = (Object[])value;
                    for (int i = 0; i < array.length; ++i) {
                        Object paramValue = array[i];
                        link.append(this.buildParameterSubstring(name, paramValue.toString()));
                        if (i >= array.length - 1) continue;
                        link.append(paramSeparator);
                    }
                } else {
                    link.append(this.buildParameterSubstring(name, value != null ? value.toString() : ""));
                }
                if (!iter.hasNext()) continue;
                link.append(paramSeparator);
            }
        }
    }

    private String buildParameterSubstring(String name, String value) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.translateAndEncode(name));
        builder.append('=');
        builder.append(this.translateAndEncode(value));
        return builder.toString();
    }

    public String translateAndEncode(String input) {
        String translatedInput = this.translateVariable(input);
        try {
            return URLEncoder.encode(translatedInput, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Could not encode URL parameter '" + input + "', returning value un-encoded", new String[0]);
            }
            return translatedInput;
        }
    }

    public String translateAndDecode(String input) {
        String translatedInput = this.translateVariable(input);
        try {
            return URLDecoder.decode(translatedInput, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Could not encode URL parameter '" + input + "', returning value un-encoded", new String[0]);
            }
            return translatedInput;
        }
    }

    private String translateVariable(String input) {
        ValueStack valueStack = ServletActionContext.getContext().getValueStack();
        return TextParseUtil.translateVariables((String)input, (ValueStack)valueStack);
    }

    @Override
    public Map<String, Object> parseQueryString(String queryString, boolean forceValueArray) {
        LinkedHashMap<String, Object> queryParams = new LinkedHashMap<String, Object>();
        if (queryString != null) {
            String[] params;
            for (String param : params = queryString.split("&")) {
                if (param.trim().length() <= 0) continue;
                String[] tmpParams = param.split("=");
                String paramName = null;
                String paramValue = "";
                if (tmpParams.length > 0) {
                    paramName = tmpParams[0];
                }
                if (tmpParams.length > 1) {
                    paramValue = tmpParams[1];
                }
                if (paramName == null) continue;
                paramName = this.translateAndDecode(paramName);
                String translatedParamValue = this.translateAndDecode(paramValue);
                if (queryParams.containsKey(paramName) || forceValueArray) {
                    Object currentParam = queryParams.get(paramName);
                    if (currentParam instanceof String) {
                        queryParams.put(paramName, new String[]{(String)currentParam, translatedParamValue});
                        continue;
                    }
                    String[] currentParamValues = (String[])currentParam;
                    if (currentParamValues != null) {
                        ArrayList<String> paramList = new ArrayList<String>(Arrays.asList(currentParamValues));
                        paramList.add(translatedParamValue);
                        queryParams.put(paramName, paramList.toArray(new String[paramList.size()]));
                        continue;
                    }
                    queryParams.put(paramName, new String[]{translatedParamValue});
                    continue;
                }
                queryParams.put(paramName, translatedParamValue);
            }
        }
        return queryParams;
    }
}

