/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.jasper;

import com.opensymphony.xwork2.util.finder.ClassLoaderInterface;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.struts2.jasper.JasperException;
import org.apache.struts2.jasper.JspCompilationContext;
import org.apache.struts2.jasper.Options;
import org.apache.struts2.jasper.compiler.Compiler;
import org.apache.struts2.jasper.compiler.JspConfig;
import org.apache.struts2.jasper.compiler.JspRuntimeContext;
import org.apache.struts2.jasper.compiler.Localizer;
import org.apache.struts2.jasper.compiler.TagPluginManager;
import org.apache.struts2.jasper.compiler.TldLocationsCache;
import org.apache.struts2.jasper.servlet.JspCServletContext;
import org.apache.struts2.jasper.xmlparser.ParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspC
implements Options {
    public static final String DEFAULT_IE_CLASS_ID = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    protected static Log log = LogFactory.getLog(JspC.class);
    protected static final String SWITCH_VERBOSE = "-v";
    protected static final String SWITCH_HELP = "-help";
    protected static final String SWITCH_OUTPUT_DIR = "-d";
    protected static final String SWITCH_PACKAGE_NAME = "-p";
    protected static final String SWITCH_CACHE = "-cache";
    protected static final String SWITCH_CLASS_NAME = "-c";
    protected static final String SWITCH_FULL_STOP = "--";
    protected static final String SWITCH_COMPILE = "-compile";
    protected static final String SWITCH_SOURCE = "-source";
    protected static final String SWITCH_TARGET = "-target";
    protected static final String SWITCH_URI_BASE = "-uribase";
    protected static final String SWITCH_URI_ROOT = "-uriroot";
    protected static final String SWITCH_FILE_WEBAPP = "-webapp";
    protected static final String SWITCH_WEBAPP_INC = "-webinc";
    protected static final String SWITCH_WEBAPP_XML = "-webxml";
    protected static final String SWITCH_MAPPED = "-mapped";
    protected static final String SWITCH_XPOWERED_BY = "-xpoweredBy";
    protected static final String SWITCH_TRIM_SPACES = "-trimSpaces";
    protected static final String SWITCH_CLASSPATH = "-classpath";
    protected static final String SWITCH_DIE = "-die";
    protected static final String SWITCH_POOLING = "-poolingEnabled";
    protected static final String SWITCH_ENCODING = "-javaEncoding";
    protected static final String SWITCH_SMAP = "-smap";
    protected static final String SWITCH_DUMP_SMAP = "-dumpsmap";
    protected static final String SHOW_SUCCESS = "-s";
    protected static final String LIST_ERRORS = "-l";
    protected static final int INC_WEBXML = 10;
    protected static final int ALL_WEBXML = 20;
    protected static final int DEFAULT_DIE_LEVEL = 1;
    protected static final int NO_DIE_LEVEL = 0;
    protected static final String[] insertBefore = new String[]{"</web-app>", "<servlet-mapping>", "<session-config>", "<mime-mapping>", "<welcome-file-list>", "<error-page>", "<taglib>", "<resource-env-ref>", "<resource-ref>", "<security-constraint>", "<login-config>", "<security-role>", "<env-entry>", "<ejb-ref>", "<ejb-local-ref>"};
    protected static int die;
    protected String classPath = null;
    protected URLClassLoader loader = null;
    protected boolean trimSpaces = false;
    protected boolean genStringAsCharArray = false;
    protected boolean xpoweredBy;
    protected boolean mappedFile = false;
    protected boolean poolingEnabled = true;
    protected File scratchDir;
    protected String ieClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    protected String targetPackage;
    protected String targetClassName;
    protected String uriBase;
    protected String uriRoot;
    protected int dieLevel;
    protected boolean helpNeeded = false;
    protected boolean compile = false;
    protected boolean smapSuppressed = true;
    protected boolean smapDumped = false;
    protected boolean caching = true;
    protected Map cache = new HashMap();
    protected String compiler = null;
    protected String compilerTargetVM = "1.4";
    protected String compilerSourceVM = "1.4";
    protected boolean classDebugInfo = true;
    protected boolean failOnError = true;
    protected List extensions;
    protected List pages = new Vector();
    protected boolean errorOnUseBeanInvalidClassAttribute = true;
    protected String javaEncoding = "UTF-8";
    protected String webxmlFile;
    protected int webxmlLevel;
    protected boolean addWebXmlMappings = false;
    protected Writer mapout;
    protected CharArrayWriter servletout;
    protected CharArrayWriter mappingout;
    protected JspCServletContext context;
    protected JspRuntimeContext rctxt;
    protected TldLocationsCache tldLocationsCache = null;
    protected JspConfig jspConfig = null;
    protected TagPluginManager tagPluginManager = null;
    protected boolean verbose = false;
    protected boolean listErrors = false;
    protected boolean showSuccess = false;
    protected int argPos;
    protected boolean fullstop = false;
    protected String[] args;
    private String sourceCode;
    private ClassLoaderInterface classLoaderInterface;

    public static void main(String[] arg) {
        block6: {
            if (arg.length == 0) {
                System.out.println(Localizer.getMessage("jspc.usage"));
            } else {
                try {
                    JspC jspc = new JspC();
                    jspc.setArgs(arg);
                    if (jspc.helpNeeded) {
                        System.out.println(Localizer.getMessage("jspc.usage"));
                    } else {
                        jspc.execute();
                    }
                }
                catch (JasperException je) {
                    System.err.println((Object)je);
                    if (die == 0) break block6;
                    System.exit(die);
                }
            }
        }
    }

    public void setArgs(String[] arg) throws JasperException {
        String file;
        String tok;
        this.args = arg;
        die = this.dieLevel = 0;
        while ((tok = this.nextArg()) != null) {
            if (tok.equals(SWITCH_VERBOSE)) {
                this.verbose = true;
                this.showSuccess = true;
                this.listErrors = true;
                continue;
            }
            if (tok.equals(SWITCH_PACKAGE_NAME)) {
                this.targetPackage = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_COMPILE)) {
                this.compile = true;
                continue;
            }
            if (tok.equals(SWITCH_CLASS_NAME)) {
                this.targetClassName = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_URI_BASE)) {
                this.uriBase = this.nextArg();
                continue;
            }
            if (tok.equals(SHOW_SUCCESS)) {
                this.showSuccess = true;
                continue;
            }
            if (tok.equals(LIST_ERRORS)) {
                this.listErrors = true;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_INC)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 10;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_XML)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 20;
                continue;
            }
            if (tok.equals(SWITCH_MAPPED)) {
                this.mappedFile = true;
                continue;
            }
            if (tok.equals(SWITCH_XPOWERED_BY)) {
                this.xpoweredBy = true;
                continue;
            }
            if (tok.equals(SWITCH_TRIM_SPACES)) {
                this.setTrimSpaces(true);
                continue;
            }
            if (tok.equals(SWITCH_CACHE)) {
                tok = this.nextArg();
                if ("false".equals(tok)) {
                    this.caching = false;
                    continue;
                }
                this.caching = true;
                continue;
            }
            if (tok.equals(SWITCH_CLASSPATH)) {
                this.setClassPath(this.nextArg());
                continue;
            }
            if (tok.startsWith(SWITCH_DIE)) {
                try {
                    this.dieLevel = Integer.parseInt(tok.substring(SWITCH_DIE.length()));
                }
                catch (NumberFormatException nfe) {
                    this.dieLevel = 1;
                }
                die = this.dieLevel;
                continue;
            }
            if (tok.equals(SWITCH_HELP)) {
                this.helpNeeded = true;
                continue;
            }
            if (tok.equals(SWITCH_POOLING)) {
                tok = this.nextArg();
                if ("false".equals(tok)) {
                    this.poolingEnabled = false;
                    continue;
                }
                this.poolingEnabled = true;
                continue;
            }
            if (tok.equals(SWITCH_ENCODING)) {
                this.setJavaEncoding(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_SOURCE)) {
                this.setCompilerSourceVM(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_TARGET)) {
                this.setCompilerTargetVM(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_SMAP)) {
                this.smapSuppressed = false;
                continue;
            }
            if (tok.equals(SWITCH_DUMP_SMAP)) {
                this.smapDumped = true;
                continue;
            }
            if (tok.startsWith("-")) {
                throw new JasperException("Unrecognized option: " + tok + ".  Use -help for help.");
            }
            if (this.fullstop) break;
            --this.argPos;
            break;
        }
        while ((file = this.nextFile()) != null) {
            this.pages.add(file);
        }
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setClassLoaderInterface(ClassLoaderInterface classLoaderInterface) {
        this.classLoaderInterface = classLoaderInterface;
    }

    public Set<String> getTldAbsolutePaths() {
        return this.tldLocationsCache.getAbsolutePathsOfLocations();
    }

    @Override
    public boolean getKeepGenerated() {
        return true;
    }

    @Override
    public boolean getTrimSpaces() {
        return this.trimSpaces;
    }

    public void setTrimSpaces(boolean ts) {
        this.trimSpaces = ts;
    }

    @Override
    public boolean isPoolingEnabled() {
        return this.poolingEnabled;
    }

    public void setPoolingEnabled(boolean poolingEnabled) {
        this.poolingEnabled = poolingEnabled;
    }

    @Override
    public boolean isXpoweredBy() {
        return this.xpoweredBy;
    }

    public void setXpoweredBy(boolean xpoweredBy) {
        this.xpoweredBy = xpoweredBy;
    }

    @Override
    public boolean getDisplaySourceFragment() {
        return true;
    }

    @Override
    public boolean getErrorOnUseBeanInvalidClassAttribute() {
        return this.errorOnUseBeanInvalidClassAttribute;
    }

    public void setErrorOnUseBeanInvalidClassAttribute(boolean b) {
        this.errorOnUseBeanInvalidClassAttribute = b;
    }

    public int getTagPoolSize() {
        return 5;
    }

    @Override
    public boolean getMappedFile() {
        return this.mappedFile;
    }

    public Object getProtectionDomain() {
        return null;
    }

    @Override
    @Deprecated
    public boolean getSendErrorToClient() {
        return true;
    }

    public void setClassDebugInfo(boolean b) {
        this.classDebugInfo = b;
    }

    @Override
    public boolean getClassDebugInfo() {
        return this.classDebugInfo;
    }

    @Override
    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    @Override
    public Map getCache() {
        return this.cache;
    }

    @Override
    public int getCheckInterval() {
        return 0;
    }

    @Override
    public int getModificationTestInterval() {
        return 0;
    }

    @Override
    public boolean getDevelopment() {
        return false;
    }

    @Override
    public boolean isSmapSuppressed() {
        return this.smapSuppressed;
    }

    public void setSmapSuppressed(boolean smapSuppressed) {
        this.smapSuppressed = smapSuppressed;
    }

    @Override
    public boolean isSmapDumped() {
        return this.smapDumped;
    }

    public void setSmapDumped(boolean smapDumped) {
        this.smapDumped = smapDumped;
    }

    public void setGenStringAsCharArray(boolean genStringAsCharArray) {
        this.genStringAsCharArray = genStringAsCharArray;
    }

    @Override
    public boolean genStringAsCharArray() {
        return this.genStringAsCharArray;
    }

    public void setIeClassId(String ieClassId) {
        this.ieClassId = ieClassId;
    }

    @Override
    public String getIeClassId() {
        return this.ieClassId;
    }

    @Override
    public File getScratchDir() {
        return this.scratchDir;
    }

    public Class getJspCompilerPlugin() {
        return null;
    }

    public String getJspCompilerPath() {
        return null;
    }

    @Override
    public String getCompiler() {
        return this.compiler;
    }

    public void setCompiler(String c) {
        this.compiler = c;
    }

    @Override
    public String getCompilerClassName() {
        return null;
    }

    @Override
    public String getCompilerTargetVM() {
        return this.compilerTargetVM;
    }

    public void setCompilerTargetVM(String vm) {
        this.compilerTargetVM = vm;
    }

    @Override
    public String getCompilerSourceVM() {
        return this.compilerSourceVM;
    }

    public void setCompilerSourceVM(String vm) {
        this.compilerSourceVM = vm;
    }

    @Override
    public TldLocationsCache getTldLocationsCache() {
        return this.tldLocationsCache;
    }

    @Override
    public String getJavaEncoding() {
        return this.javaEncoding;
    }

    public void setJavaEncoding(String encodingName) {
        this.javaEncoding = encodingName;
    }

    @Override
    public boolean getFork() {
        return false;
    }

    @Override
    public String getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        return System.getProperty("java.class.path");
    }

    public void setClassPath(String s) {
        this.classPath = s;
    }

    public List getExtensions() {
        return this.extensions;
    }

    protected void addExtension(String extension) {
        if (extension != null) {
            if (this.extensions == null) {
                this.extensions = new Vector();
            }
            this.extensions.add(extension);
        }
    }

    public void setJspFiles(String jspFiles) {
        if (jspFiles == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(jspFiles, ",");
        while (tok.hasMoreTokens()) {
            this.pages.add(tok.nextToken());
        }
    }

    public void setCompile(boolean b) {
        this.compile = b;
    }

    public void setVerbose(int level) {
        if (level > 0) {
            this.verbose = true;
            this.showSuccess = true;
            this.listErrors = true;
        }
    }

    public void setValidateXml(boolean b) {
        ParserUtils.validating = b;
    }

    public void setListErrors(boolean b) {
        this.listErrors = b;
    }

    public void setPackage(String p) {
        this.targetPackage = p;
    }

    public void setClassName(String p) {
        this.targetClassName = p;
    }

    public void setAddWebXmlMappings(boolean b) {
        this.addWebXmlMappings = b;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    @Override
    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    @Override
    public TagPluginManager getTagPluginManager() {
        return this.tagPluginManager;
    }

    public void generateWebMapping(String file, JspCompilationContext clctxt) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating web mapping for file " + file + " using compilation context " + clctxt));
        }
        String className = clctxt.getServletClassName();
        String packageName = clctxt.getServletPackageName();
        String thisServletName = "".equals(packageName) ? className : packageName + '.' + className;
        if (this.servletout != null) {
            this.servletout.write("\n    <servlet>\n        <servlet-name>");
            this.servletout.write(thisServletName);
            this.servletout.write("</servlet-name>\n        <servlet-class>");
            this.servletout.write(thisServletName);
            this.servletout.write("</servlet-class>\n    </servlet>\n");
        }
        if (this.mappingout != null) {
            this.mappingout.write("\n    <servlet-mapping>\n        <servlet-name>");
            this.mappingout.write(thisServletName);
            this.mappingout.write("</servlet-name>\n        <url-pattern>");
            this.mappingout.write(file.replace('\\', '/'));
            this.mappingout.write("</url-pattern>\n    </servlet-mapping>\n");
        }
    }

    protected void mergeIntoWebXml() throws IOException {
        int n;
        File webappBase = new File(this.uriRoot);
        File webXml = new File(webappBase, "WEB-INF/web.xml");
        File webXml2 = new File(webappBase, "WEB-INF/web2.xml");
        String insertStartMarker = Localizer.getMessage("jspc.webinc.insertStart");
        String insertEndMarker = Localizer.getMessage("jspc.webinc.insertEnd");
        BufferedReader reader = new BufferedReader(new FileReader(webXml));
        BufferedReader fragmentReader = new BufferedReader(new FileReader(this.webxmlFile));
        PrintWriter writer = new PrintWriter(new FileWriter(webXml2));
        int pos = -1;
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(insertStartMarker) >= 0) {
                do {
                    if ((line = reader.readLine()) != null) continue;
                    return;
                } while (line.indexOf(insertEndMarker) < 0);
                line = reader.readLine();
                line = reader.readLine();
                if (line == null) {
                    return;
                }
            }
            for (int i = 0; i < insertBefore.length && (pos = line.indexOf(insertBefore[i])) < 0; ++i) {
            }
            if (pos >= 0) {
                writer.print(line.substring(0, pos));
                break;
            }
            writer.println(line);
        }
        writer.println(insertStartMarker);
        while (true) {
            String line2;
            if ((line2 = fragmentReader.readLine()) == null) break;
            writer.println(line2);
        }
        writer.println();
        writer.println(insertEndMarker);
        writer.println();
        for (int i = 0; i < pos; ++i) {
            writer.print(" ");
        }
        writer.println(line.substring(pos));
        while ((line = reader.readLine()) != null) {
            writer.println(line);
        }
        writer.close();
        reader.close();
        fragmentReader.close();
        FileInputStream fis = new FileInputStream(webXml2);
        FileOutputStream fos = new FileOutputStream(webXml);
        byte[] buf = new byte[512];
        while ((n = fis.read(buf)) >= 0) {
            fos.write(buf, 0, n);
        }
        fis.close();
        fos.close();
        webXml2.delete();
        new File(this.webxmlFile).delete();
    }

    /*
     * Loose catch block
     */
    private void processFile(String file) throws JasperException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing file: " + file));
        }
        ClassLoader originalClassLoader = null;
        try {
            if (this.scratchDir == null) {
                String temp = System.getProperty("java.io.tmpdir");
                if (temp == null) {
                    temp = "";
                }
                this.scratchDir = new File(new File(temp).getAbsolutePath());
            }
            String jspUri = file.replace('\\', '/');
            JspCompilationContext clctxt = new JspCompilationContext(jspUri, false, (Options)this, (ServletContext)this.context, null, this.rctxt, this.classLoaderInterface);
            if (this.targetClassName != null && this.targetClassName.length() > 0) {
                clctxt.setServletClassName(this.targetClassName);
                this.targetClassName = null;
            }
            if (this.targetPackage != null) {
                clctxt.setServletPackageName(this.targetPackage);
            }
            originalClassLoader = Thread.currentThread().getContextClassLoader();
            if (this.loader == null) {
                this.initClassLoader(clctxt);
            }
            Thread.currentThread().setContextClassLoader(this.loader);
            clctxt.setClassLoader(this.loader);
            clctxt.setClassPath(this.classPath);
            Compiler clc = clctxt.createCompiler();
            if (clc.isOutDated(this.compile)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(jspUri + " is out dated, compiling..."));
                }
                clc.compile(this.compile, true);
            }
            this.generateWebMapping(file, clctxt);
            if (this.showSuccess) {
                log.info((Object)("Built File: " + file));
            }
            this.sourceCode = clctxt.getSourceCode();
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
        catch (JasperException je) {
            Object rootCause = je;
            while (rootCause instanceof JasperException && rootCause.getRootCause() != null) {
                rootCause = rootCause.getRootCause();
            }
            if (rootCause != je) {
                log.error((Object)Localizer.getMessage("jspc.error.generalException", file), (Throwable)rootCause);
            }
            if (this.getFailOnError()) {
                throw je;
            }
            log.error((Object)je.getMessage(), (Throwable)((Object)je));
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException && log.isWarnEnabled()) {
                log.warn((Object)Localizer.getMessage("jspc.error.fileDoesNotExist", e.getMessage()));
            }
            throw new JasperException(e);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    public void scanFiles(File base) throws JasperException {
        Stack<String> dirs = new Stack<String>();
        dirs.push(base.toString());
        if (this.getExtensions() == null || this.getExtensions().size() < 2) {
            this.addExtension("jsp");
            this.addExtension("jspx");
        }
        while (!dirs.isEmpty()) {
            String s = (String)dirs.pop();
            File f = new File(s);
            if (!f.exists() || !f.isDirectory()) continue;
            String[] files = f.list();
            for (int i = 0; files != null && i < files.length; ++i) {
                File f2 = new File(s, files[i]);
                if (f2.isDirectory()) {
                    dirs.push(f2.getPath());
                    continue;
                }
                String path = f2.getPath();
                String uri = path.substring(this.uriRoot.length());
                String ext = files[i].substring(files[i].lastIndexOf(46) + 1);
                if (!this.getExtensions().contains(ext) && !this.jspConfig.isJspPage(uri)) continue;
                this.pages.add(path);
            }
        }
    }

    public void execute() throws JasperException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("execute() starting for " + this.pages.size() + " pages."));
        }
        try {
            if (this.context == null) {
                this.initServletContext();
            }
            this.initWebXml();
            Iterator iter = this.pages.iterator();
            while (iter.hasNext()) {
                String nextjsp = iter.next().toString();
                this.processFile(nextjsp);
            }
            this.completeWebXml();
        }
        catch (JasperException je) {
            Object rootCause = je;
            while (rootCause instanceof JasperException && rootCause.getRootCause() != null) {
                rootCause = rootCause.getRootCause();
            }
            if (rootCause != je) {
                ((Throwable)rootCause).printStackTrace();
            }
            throw je;
        }
    }

    protected String nextArg() {
        if (this.argPos >= this.args.length || (this.fullstop = SWITCH_FULL_STOP.equals(this.args[this.argPos]))) {
            return null;
        }
        return this.args[this.argPos++];
    }

    protected String nextFile() {
        if (this.fullstop) {
            ++this.argPos;
        }
        if (this.argPos >= this.args.length) {
            return null;
        }
        return this.args[this.argPos++];
    }

    protected void initWebXml() {
        try {
            if (this.webxmlLevel >= 10) {
                File fmapings = new File(this.webxmlFile);
                this.mapout = new FileWriter(fmapings);
                this.servletout = new CharArrayWriter();
                this.mappingout = new CharArrayWriter();
            } else {
                this.mapout = null;
                this.servletout = null;
                this.mappingout = null;
            }
            if (this.webxmlLevel >= 20) {
                this.mapout.write(Localizer.getMessage("jspc.webxml.header"));
                this.mapout.flush();
            } else if (this.webxmlLevel >= 10 && !this.addWebXmlMappings) {
                this.mapout.write(Localizer.getMessage("jspc.webinc.header"));
                this.mapout.flush();
            }
        }
        catch (IOException ioe) {
            this.mapout = null;
            this.servletout = null;
            this.mappingout = null;
        }
    }

    protected void completeWebXml() {
        if (this.mapout != null) {
            try {
                this.servletout.writeTo(this.mapout);
                this.mappingout.writeTo(this.mapout);
                if (this.webxmlLevel >= 20) {
                    this.mapout.write(Localizer.getMessage("jspc.webxml.footer"));
                } else if (this.webxmlLevel >= 10 && !this.addWebXmlMappings) {
                    this.mapout.write(Localizer.getMessage("jspc.webinc.footer"));
                }
                this.mapout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void initServletContext() {
        this.context = new JspCServletContext(new PrintWriter(System.out), this.classLoaderInterface);
        this.tldLocationsCache = new TldLocationsCache(this.context, true);
        this.rctxt = new JspRuntimeContext(this.context, this);
        this.jspConfig = new JspConfig(this.context);
        this.tagPluginManager = new TagPluginManager(this.context);
    }

    private void initClassLoader(JspCompilationContext clctxt) throws IOException {
        this.classPath = this.getClassPath();
        ClassLoader jspcLoader = this.getClass().getClassLoader();
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(this.classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            try {
                File libFile = new File(path);
                urls.add(libFile.toURL());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }
        URL[] urlsA = new URL[urls.size()];
        urls.toArray(urlsA);
        this.loader = new URLClassLoader(urlsA, this.getClass().getClassLoader());
    }

    protected void locateUriRoot(File f) {
        String tUriBase = this.uriBase;
        if (tUriBase == null) {
            tUriBase = "/";
        }
        try {
            if (f.exists()) {
                f = new File(f.getAbsolutePath());
                while (f != null) {
                    String fParent;
                    File g = new File(f, "WEB-INF");
                    if (g.exists() && g.isDirectory()) {
                        this.uriRoot = f.getCanonicalPath();
                        this.uriBase = tUriBase;
                        if (!log.isInfoEnabled()) break;
                        log.info((Object)Localizer.getMessage("jspc.implicit.uriRoot", this.uriRoot));
                        break;
                    }
                    if (f.exists() && f.isDirectory()) {
                        tUriBase = "/" + f.getName() + "/" + tUriBase;
                    }
                    if ((fParent = f.getParent()) == null) break;
                    f = new File(fParent);
                }
                if (this.uriRoot != null) {
                    File froot = new File(this.uriRoot);
                    this.uriRoot = froot.getCanonicalPath();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

