/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.PackageProvider;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.osgi.BundleAccessor;
import org.apache.struts2.osgi.BundleClassLoaderInterface;
import org.apache.struts2.osgi.BundlePackageLoader;
import org.apache.struts2.osgi.OsgiHost;
import org.apache.struts2.osgi.loaders.VelocityBundleResourceLoader;
import org.apache.struts2.views.velocity.VelocityManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class OsgiConfigurationProvider
implements PackageProvider,
BundleListener {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiConfigurationProvider.class);
    private Configuration configuration;
    private ObjectFactory objectFactory;
    private FileManager fileManager;
    private OsgiHost osgiHost;
    private BundleContext bundleContext;
    private BundleAccessor bundleAccessor;
    private boolean bundlesChanged = false;
    private ServletContext servletContext;

    public void init(Configuration configuration) throws ConfigurationException {
        this.osgiHost = (OsgiHost)this.servletContext.getAttribute("__struts_osgi_host");
        this.bundleContext = this.osgiHost.getBundleContext();
        this.bundleAccessor.setBundleContext(this.bundleContext);
        this.bundleAccessor.setOsgiHost(this.osgiHost);
        this.configuration = configuration;
        this.servletContext.setAttribute("__current_class_loader_interface", (Object)new BundleClassLoaderInterface());
    }

    public synchronized void loadPackages() throws ConfigurationException {
        ActionContext ctx;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loading packages from XML and Convention on startup", new String[0]);
        }
        if ((ctx = ActionContext.getContext()) == null) {
            ctx = new ActionContext(new HashMap());
            ActionContext.setContext((ActionContext)ctx);
        }
        HashSet<String> bundleNames = new HashSet<String>();
        for (Bundle bundle : this.osgiHost.getBundles().values()) {
            String bundleName = bundle.getSymbolicName();
            if (!this.shouldProcessBundle(bundle) || bundleNames.contains(bundleName)) continue;
            bundleNames.add(bundleName);
            this.loadConfigFromBundle(bundle);
        }
        this.bundlesChanged = false;
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfigFromBundle(Bundle bundle) {
        ActionContext ctx;
        String bundleName = bundle.getSymbolicName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading packages from bundle [#0]", new String[]{bundleName});
        }
        if ((ctx = ActionContext.getContext()) == null) {
            ctx = new ActionContext(new HashMap());
            ActionContext.setContext((ActionContext)ctx);
        }
        try {
            ctx.put("__current_class_loader_interface", (Object)new BundleClassLoaderInterface());
            ctx.put("__bundle_name__", (Object)bundleName);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loading XML config from bundle [#0]", new String[]{bundleName});
            }
            BundlePackageLoader loader = new BundlePackageLoader();
            for (PackageConfig pkg : loader.loadPackages(bundle, this.bundleContext, this.objectFactory, this.fileManager, this.configuration.getPackageConfigs())) {
                this.configuration.addPackageConfig(pkg.getName(), pkg);
                this.bundleAccessor.addPackageFromBundle(bundle, pkg.getName());
            }
            HashSet packagesBeforeLoading = new HashSet(this.configuration.getPackageConfigNames());
            PackageProvider conventionPackageProvider = (PackageProvider)this.configuration.getContainer().getInstance(PackageProvider.class, "convention.packageProvider");
            if (conventionPackageProvider != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Loading Convention config from bundle [#0]", new String[]{bundleName});
                }
                conventionPackageProvider.loadPackages();
            }
            HashSet packagesAfterLoading = new HashSet(this.configuration.getPackageConfigNames());
            packagesAfterLoading.removeAll(packagesBeforeLoading);
            if (!packagesAfterLoading.isEmpty()) {
                for (String packageName : packagesAfterLoading) {
                    this.bundleAccessor.addPackageFromBundle(bundle, packageName);
                }
            }
            if (this.configuration.getRuntimeConfiguration() != null) {
                this.configuration.rebuildRuntimeConfiguration();
            }
        }
        finally {
            ctx.put("__bundle_name__", null);
            ctx.put("__current_class_loader_interface", null);
        }
    }

    protected boolean shouldProcessBundle(Bundle bundle) {
        String strutsEnabled = (String)bundle.getHeaders().get("Struts2-Enabled");
        return "true".equalsIgnoreCase(strutsEnabled);
    }

    public synchronized boolean needsReload() {
        return this.bundlesChanged;
    }

    @Inject
    public void setObjectFactory(ObjectFactory factory) {
        this.objectFactory = factory;
    }

    @Inject
    public void setBundleAccessor(BundleAccessor acc) {
        this.bundleAccessor = acc;
    }

    @Inject
    public void setVelocityManager(VelocityManager vm) {
        Properties props = new Properties();
        props.setProperty("osgi.resource.loader.description", "OSGI bundle loader");
        props.setProperty("osgi.resource.loader.class", VelocityBundleResourceLoader.class.getName());
        props.setProperty("resource.loader", "strutsfile,strutsclass,osgi");
        vm.setVelocityProperties(props);
    }

    @Inject
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setFileManagerFactory(FileManagerFactory fmFactory) {
        this.fileManager = fmFactory.getFileManager();
    }

    public void destroy() {
        block2: {
            try {
                this.osgiHost.destroy();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("Failed to stop OSGi container", (Throwable)e, new String[0]);
            }
        }
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        Bundle bundle = bundleEvent.getBundle();
        String bundleName = bundle.getSymbolicName();
        if (bundleName != null && this.shouldProcessBundle(bundle)) {
            switch (bundleEvent.getType()) {
                case 2: {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("The bundlde [#0] has been activated and will be scanned for struts configuration", new String[]{bundleName});
                    }
                    this.loadConfigFromBundle(bundle);
                    break;
                }
                case 4: {
                    this.onBundleStopped(bundle);
                }
            }
        }
    }

    protected void onBundleStopped(Bundle bundle) {
        Set<String> packages = this.bundleAccessor.getPackagesByBundle(bundle);
        if (!packages.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("The bundle [#0] has been stopped. The packages [#1] will be disabled", new String[]{bundle.getSymbolicName(), StringUtils.join(packages, (String)",")});
            }
            for (String packageName : packages) {
                this.configuration.removePackageConfig(packageName);
            }
        }
    }
}

